% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImgFileComparator.R
\name{ImgFileComparator}
\alias{ImgFileComparator}
\title{ImgFileComparator.R}
\description{
ImgFileComparator.R

ImgFileComparator.R
}
\details{
Specialiced comparator for image file (jpg, jpef, png)  comparison.
This comparator contains the custom handling for handling only img content
part for the comparison.
}
\examples{

# The normal way for creating a comparator would be to call the generic
# factory method verifyr2::create_comparator that will automatically create
# the correct comparator instance based on the file types.

file1 <- 'my_file1.jpg'
file2 <- 'my_file2.jpg'
comparator <- verifyr2::create_comparator(file1, file2)

# If needed, an explicit comparator can be created as well.

file1 <- 'my_file1.png'
file2 <- 'my_file2.png'
comparator <- ImgFileComparator$new(file1, file2)

# This comparator has also second explicit creation method that is used
# by the library for processing embedded image contents.

image1_raw <- 'raw hex vector data'
image2_raw <- 'raw hex vector data'
comparator <- ImgFileComparator$new(NULL, NULL, image1_raw, image2_raw)

}
\section{Super classes}{
\code{\link[verifyr2:FileComparator]{verifyr2::FileComparator}} -> \code{\link[verifyr2:BinaryFileComparator]{verifyr2::BinaryFileComparator}} -> \code{ImgFileComparator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{image1_raw}}{extracted raw data for image1.}

\item{\code{image2_raw}}{extracted raw data for image2.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ImgFileComparator-new}{\code{ImgFileComparator$new()}}
\item \href{#method-ImgFileComparator-vrf_details_inner}{\code{ImgFileComparator$vrf_details_inner()}}
\item \href{#method-ImgFileComparator-vrf_details_inner_from_raw}{\code{ImgFileComparator$vrf_details_inner_from_raw()}}
\item \href{#method-ImgFileComparator-vrf_details_inner_from_files}{\code{ImgFileComparator$vrf_details_inner_from_files()}}
\item \href{#method-ImgFileComparator-vrf_details_supported}{\code{ImgFileComparator$vrf_details_supported()}}
\item \href{#method-ImgFileComparator-clone}{\code{ImgFileComparator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug'><code>verifyr2::FileComparator$vrf_add_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug_files"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug_files'><code>verifyr2::FileComparator$vrf_add_debug_files()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_close_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_close_debug'><code>verifyr2::FileComparator$vrf_close_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_details"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_details'><code>verifyr2::FileComparator$vrf_details()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_open_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_open_debug'><code>verifyr2::FileComparator$vrf_open_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_option_value"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_option_value'><code>verifyr2::FileComparator$vrf_option_value()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_summary"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_summary'><code>verifyr2::FileComparator$vrf_summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="BinaryFileComparator" data-id="vrf_contents"><a href='../../verifyr2/html/BinaryFileComparator.html#method-BinaryFileComparator-vrf_contents'><code>verifyr2::BinaryFileComparator$vrf_contents()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="BinaryFileComparator" data-id="vrf_contents_inner"><a href='../../verifyr2/html/BinaryFileComparator.html#method-BinaryFileComparator-vrf_contents_inner'><code>verifyr2::BinaryFileComparator$vrf_contents_inner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="BinaryFileComparator" data-id="vrf_summary_inner"><a href='../../verifyr2/html/BinaryFileComparator.html#method-BinaryFileComparator-vrf_summary_inner'><code>verifyr2::BinaryFileComparator$vrf_summary_inner()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImgFileComparator-new"></a>}}
\if{latex}{\out{\hypertarget{method-ImgFileComparator-new}{}}}
\subsection{Method \code{new()}}{
Initialize a ImgFileComparator instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImgFileComparator$new(file1 = NULL, file2 = NULL, raw1 = NULL, raw2 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file1}}{First file to compare.}

\item{\code{file2}}{Second file to compare.}

\item{\code{raw1}}{First image in raw format to compare.}

\item{\code{raw2}}{Second image in raw format to compare.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImgFileComparator-vrf_details_inner"></a>}}
\if{latex}{\out{\hypertarget{method-ImgFileComparator-vrf_details_inner}{}}}
\subsection{Method \code{vrf_details_inner()}}{
Method for comparing the inner part for the details query. This method
can be overwritten by more specialized comparator classes. This method is
intended to be called only by the comparator classes in the processing
and shouldn't be called directly by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImgFileComparator$vrf_details_inner(config, omit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImgFileComparator-vrf_details_inner_from_raw"></a>}}
\if{latex}{\out{\hypertarget{method-ImgFileComparator-vrf_details_inner_from_raw}{}}}
\subsection{Method \code{vrf_details_inner_from_raw()}}{
Internal method for comparing the earlier populated raw image contents in
details and generating the difference highlight image in case differences
are found.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImgFileComparator$vrf_details_inner_from_raw(config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImgFileComparator-vrf_details_inner_from_files"></a>}}
\if{latex}{\out{\hypertarget{method-ImgFileComparator-vrf_details_inner_from_files}{}}}
\subsection{Method \code{vrf_details_inner_from_files()}}{
Method for comparing the inner part for the details query with the file
names as the base arguments. This is a part of a group of image
processing functions that work with different image abstractions (file,
image, raw image). These methods are intended to improve the performance
so that best suiting method version can be used depending on what data is
available from the earlier method calls to the same comparator instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImgFileComparator$vrf_details_inner_from_files(config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImgFileComparator-vrf_details_supported"></a>}}
\if{latex}{\out{\hypertarget{method-ImgFileComparator-vrf_details_supported}{}}}
\subsection{Method \code{vrf_details_supported()}}{
Inherited method for indicating whether detailed comparison is available
with the current comparator. Returns an empty string if the comparator is
is supported, otherwise a string that will be concatenated with the
summary string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImgFileComparator$vrf_details_supported(config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ImgFileComparator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ImgFileComparator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImgFileComparator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
