% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RtfFileComparator.R
\name{RtfFileComparator}
\alias{RtfFileComparator}
\title{RtfFileComparator.R}
\description{
RtfFileComparator.R

RtfFileComparator.R
}
\details{
Specialiced comparator for RTF file comparison.
This comparator contains the custom handling for handling only RTF content
part for the comparison.
}
\examples{

# The normal way for creating a comparator would be to call the generic
# factory method verifyr2::create_comparator that will automatically create
# the correct comparator instance based on the file types.

file1 <- 'my_file1.rtf'
file2 <- 'my_file2.rtf'
comparator <- verifyr2::create_comparator(file1, file2)

# If needed, an explicit comparator can be created as well.

file1 <- 'my_file1.rtf'
file2 <- 'my_file2.rft'
comparator <- RtfFileComparator$new(file1, file2)

}
\section{Super classes}{
\code{\link[verifyr2:FileComparator]{verifyr2::FileComparator}} -> \code{\link[verifyr2:BinaryFileComparator]{verifyr2::BinaryFileComparator}} -> \code{\link[verifyr2:TxtFileComparator]{verifyr2::TxtFileComparator}} -> \code{\link[verifyr2:TxtWithImagesFileComparator]{verifyr2::TxtWithImagesFileComparator}} -> \code{RtfFileComparator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RtfFileComparator-vrf_contents}{\code{RtfFileComparator$vrf_contents()}}
\item \href{#method-RtfFileComparator-vrf_images}{\code{RtfFileComparator$vrf_images()}}
\item \href{#method-RtfFileComparator-clone}{\code{RtfFileComparator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug'><code>verifyr2::FileComparator$vrf_add_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug_files"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug_files'><code>verifyr2::FileComparator$vrf_add_debug_files()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_close_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_close_debug'><code>verifyr2::FileComparator$vrf_close_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_details"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_details'><code>verifyr2::FileComparator$vrf_details()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_open_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_open_debug'><code>verifyr2::FileComparator$vrf_open_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_option_value"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_option_value'><code>verifyr2::FileComparator$vrf_option_value()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_summary"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_summary'><code>verifyr2::FileComparator$vrf_summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtFileComparator" data-id="vrf_contents_inner"><a href='../../verifyr2/html/TxtFileComparator.html#method-TxtFileComparator-vrf_contents_inner'><code>verifyr2::TxtFileComparator$vrf_contents_inner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtFileComparator" data-id="vrf_details_supported"><a href='../../verifyr2/html/TxtFileComparator.html#method-TxtFileComparator-vrf_details_supported'><code>verifyr2::TxtFileComparator$vrf_details_supported()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtWithImagesFileComparator" data-id="hex2raw"><a href='../../verifyr2/html/TxtWithImagesFileComparator.html#method-TxtWithImagesFileComparator-hex2raw'><code>verifyr2::TxtWithImagesFileComparator$hex2raw()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtWithImagesFileComparator" data-id="initialize"><a href='../../verifyr2/html/TxtWithImagesFileComparator.html#method-TxtWithImagesFileComparator-initialize'><code>verifyr2::TxtWithImagesFileComparator$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtWithImagesFileComparator" data-id="vrf_details_inner"><a href='../../verifyr2/html/TxtWithImagesFileComparator.html#method-TxtWithImagesFileComparator-vrf_details_inner'><code>verifyr2::TxtWithImagesFileComparator$vrf_details_inner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtWithImagesFileComparator" data-id="vrf_summary_inner"><a href='../../verifyr2/html/TxtWithImagesFileComparator.html#method-TxtWithImagesFileComparator-vrf_summary_inner'><code>verifyr2::TxtWithImagesFileComparator$vrf_summary_inner()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RtfFileComparator-vrf_contents"></a>}}
\if{latex}{\out{\hypertarget{method-RtfFileComparator-vrf_contents}{}}}
\subsection{Method \code{vrf_contents()}}{
Method for getting the single file contents for the comparison. The
method returns the file contents in two separate vectors inside a list.
The first vector is the file contents and the second one is the file
contents with the rows matching the omit string excluded. This method
can be overwritten by more specialized comparator classes. This method
is intended to be called only by the comparator classes in the processing
and shouldn't be called directly by the user.

For RtfComparator, only the RTF file content part is returned for
comparison.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RtfFileComparator$vrf_contents(file, config, omit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file for which to get the contents}

\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RtfFileComparator-vrf_images"></a>}}
\if{latex}{\out{\hypertarget{method-RtfFileComparator-vrf_images}{}}}
\subsection{Method \code{vrf_images()}}{
"Abstract" method for getting the raw image hex vector array from the
given source file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RtfFileComparator$vrf_images(file, config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file for which to get the embedded image details}

\item{\code{config}}{configuration values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RtfFileComparator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RtfFileComparator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RtfFileComparator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
