% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields_plot.R
\name{plotTdProbabilities}
\alias{plotTdProbabilities}
\title{Value plotting function for 24-2 or 30-2 visual field measurement:}
\usage{
plotTdProbabilities(tdprob, cex = 2, rectangle.color = "black",
  rectangle.width = 0.16, margins = c(2, 1, 2, 2) + 0.1, ...)
}
\arguments{
\item{tdprob}{a vector contains TD probs/PD probs measurement. For 24-2 VF \code{tdprob} should have 52 or 54 elements. For 30-2 VF, \code{tdprob} should have 74 or 76 elements.}

\item{cex}{a numeric variable for label size (default: 2).}

\item{rectangle.color}{a string variable defines label color (default: 'black').}

\item{rectangle.width}{a numeric variable defines label width (default: '0.16').}

\item{margins}{a vector define the plot margins (default: c(2, 1, 2, 2)+0.1).}

\item{...}{other variables to be added.}
}
\value{
value plot for TD prob and PD prob input.
}
\description{
\code{plotTdProbabilities} plots the following 24-2 or 30-2 visual field measurement: TD probs, and PD probs:
}
\examples{
data(vfseries)
tdprob = t(vfseries[1, grepl('^tdp[0-9]+', colnames(vfseries))])
plotTdProbabilities(tdprob)
title(main = "Total Deviation Probability", line = 3)
tdprob = t(vfseries[1, grepl('^pdp[0-9]+', colnames(vfseries))])
plotTdProbabilities(tdprob)
title(main = "Pattern Deviation Probability", line = 3)
}
