% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENc.GC3plot.R
\name{ENc.GC3plot}
\alias{ENc.GC3plot}
\title{ENc-GC3 scatterplot.}
\usage{
ENc.GC3plot(enc.df, gc.df)
}
\arguments{
\item{enc.df}{a data frame with ENc values.}

\item{gc.df}{a data frame with GC3 values.}
}
\value{
A ggplot object.
}
\description{
Make an ENc-GC3 scatterplot. Where the y-axis represents the ENc values and the x-axis represents the GC3 content.
The red fitting line shows the expected ENc values when codon usage bias affected solely by GC3.
}
\details{
For more information about ENc-GC3 plot \href{https://www.tandfonline.com/doi/full/10.1038/emi.2016.106}{Butt et al., 2016}.
}
\examples{

\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}
\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
enc.df.virus <- ENc.values(fasta.v)
}

gc.df <- GC.content(fasta.v)

ENc.GC3plot(enc.df.virus, gc.df)

}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
