% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SiD.value.R
\name{SiD.value}
\alias{SiD.value}
\title{Similarity Index (SiD)}
\usage{
SiD.value(rscu.host,rscu.virus)
}
\arguments{
\item{rscu.host}{a data frame with RSCU a host codon values.}

\item{rscu.virus}{a data frame with RSCU a virus codon values.}
}
\value{
A numeric represent a SiD value.
}
\description{
Measure the Similarity Index (SiD) between a virus and its host codon usage.
}
\details{
For more information about SiD \href{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0077239}{Zhou et al., 2013}.
}
\examples{

\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}
\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
fasta.h <- fasta[[2]]
RSCU.H <- RSCU.values(fasta.h)
RSCU.V <- RSCU.values(fasta.v)
}
# Calculate SiD
SiD <- SiD.value(RSCU.host, RSCU.virus)

}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
