% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mars_domain_score.R
\name{mars_domain_score}
\alias{mars_domain_score}
\title{Calculate the MARS model domain applicability score}
\usage{
mars_domain_score(
  featured_col,
  train_data,
  mars_hyperparameters,
  test_data,
  threshold_value
)
}
\arguments{
\item{featured_col}{The name of the featured column.}

\item{train_data}{A data frame containing the training data.}

\item{mars_hyperparameters}{A list of hyperparameters for the MARS model, including:
\itemize{
\item \code{num_terms}: The number of terms to include in the MARS model.
\item \code{prod_degree}: The degree of interaction terms to include.
\item \code{prune_method}: The method used for pruning the MARS model.
}}

\item{test_data}{A data frame containing the test data.}

\item{threshold_value}{The threshold value for the domain score.}
}
\value{
A tibble with the domain applicability scores.
}
\description{
This function fits a MARS (Multivariate Adaptive Regression Splines) model to
the provided data and computes a domain applicability score based on PCA distances.
}
\examples{
set.seed(123)
library(dplyr)
featured_col <- "cd_2022"
# Specifying features for training and testing procedures
train_data = viral \%>\%
  dplyr::select(cd_2022, vl_2022)
test_data = sero 
mars_hyperparameters <- list(num_terms = 3, prod_degree = 1, prune_method = "none")
threshold_value <- 0.99
# Call the function
}
