% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{usersGetFollowers}
\alias{usersGetFollowers}
\title{Returns a list of IDs of followers of the user in question, sorted by date added, most recent first}
\usage{
usersGetFollowers(
  user_id = "",
  offset = 0,
  count = 0,
  fields = "",
  name_case = "",
  drop = FALSE,
  flatten = FALSE,
  progress_bar = FALSE,
  v = getAPIVersion()
)
}
\arguments{
\item{user_id}{User ID}

\item{offset}{Offset needed to return a specific subset of followers}

\item{count}{Number of followers to return}

\item{fields}{Profile fields to return}

\item{name_case}{Case for declension of user name and surname}

\item{drop}{Drop deleted or banned followers}

\item{flatten}{Automatically flatten nested data frames into a single non-nested data frame}

\item{progress_bar}{Display progress bar}

\item{v}{Version of API}
}
\description{
Returns a list of IDs of followers of the user in question, sorted by date added, most recent first
}
\examples{
\dontrun{
my_followers <- usersGetFollowers(me())
}
}
