% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{vkOAuth}
\alias{vkOAuth}
\title{Client authorization}
\usage{
vkOAuth(client_id, scope = "friends", email, password)
}
\arguments{
\item{client_id}{Application ID}

\item{scope}{Requested application access permissions (see below).}

\item{email}{Email or phone number}

\item{password}{Password}
}
\description{
Client authorization
}
\details{
List of Available Settings of \href{https://vk.com/dev/permissions}{Access Permissions}:
\itemize{
  \item \strong{friends} Access to friends.
  \item \strong{photos} Access to photos.
  \item \strong{audio} Access to audios.
  \item \strong{video} Access to videos.
  \item \strong{docs} Access to documents.
  \item \strong{notes} Access to user notes.
  \item \strong{pages} Access to wiki pages.
  \item \strong{status} Access to user status.
  \item \strong{wall} Access to standard and advanced methods for the wall.
  \item \strong{groups} Access to user groups.
  \item \strong{messages} Access to advanced methods for messaging.
  \item \strong{notifications} Access to notifications about answers to the user.
}
}
\examples{
\dontrun{
# an example of an authenticated request
vkOAuth(client_id = 123456,
        scope = "friends,groups,messages",
        email = "your_email@example.com",
        password = "your_secret_password")

# save access token for future sessions
at <- getAccessToken()

# an example of request
me()

# an example of an authenticated request without specifying email and password
vkOAuth(client_id = 123456, scope = "friends,groups,messages")

# copy access token from browser address bar
setAccessToken("your_secret_access_token")
}
}
