% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vntrs.R
\name{vntrs}
\alias{vntrs}
\title{Variable neighborhood trust region search}
\usage{
vntrs(
  f,
  npar,
  minimize = TRUE,
  init_runs = 5L,
  init_min = -1,
  init_max = 1,
  init_iterlim = 20L,
  neighborhoods = 5L,
  neighbors = 5L,
  beta = 0.05,
  iterlim = 100L,
  tolerance = 1e-06,
  inferior_tolerance = 1e-06,
  time_limit = NULL,
  cores = 1L,
  lower = NULL,
  upper = NULL,
  collect_all = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{f}{[\code{function}]\cr
A function, returning either
\itemize{
\item a \code{numeric} objective value or
\item a \code{list} with element \code{value} and optional \code{gradient} and
\code{hessian} components
}

for a \code{numeric} parameter vector. Missing derivatives are approximated
by finite differences.}

\item{npar}{[\code{integer(1)}]\cr
The number of parameters of \code{f}.}

\item{minimize}{[\code{logical(1)}]\cr
Minimize \code{f}?}

\item{init_runs}{[\code{integer(1)}]\cr
Number of random starting points for the initialization stage.}

\item{init_min, init_max}{[\code{numeric(1)}]\cr
Lower and upper bound for the uniform sampling range during initialization.}

\item{init_iterlim}{[\code{integer(1)}]\cr
Maximum iterations of the trust-region method during initialization.}

\item{neighborhoods}{[\code{integer(1)}]\cr
Number of neighborhood expansions to perform.}

\item{neighbors}{[\code{integer(1)}]\cr
Number of neighboring points drawn in each neighborhood.}

\item{beta}{[\code{numeric(1)}]\cr
Non-negative scaling factor that controls the neighborhood expansion.}

\item{iterlim}{[\code{integer(1)}]\cr
Maximum iterations of the trust-region method during the main search.}

\item{tolerance}{[\code{numeric(1)}]\cr
Minimum distance between optima candidates to consider them distinct.}

\item{inferior_tolerance}{[\code{numeric(1)}]\cr
Maximum allowed difference from the best known objective value when deciding
if a local optimum should be discarded early.}

\item{time_limit}{[\code{integer(1)} | \code{NULL}]\cr
Optional time limit (in seconds) for the search. If reached, the search stops
early with a warning.}

\item{cores}{[\code{integer(1)}]\cr
Number of CPU cores used for parallel evaluation.}

\item{lower, upper}{[\code{numeric(npar)}  | \code{NULL}]\cr
Optional lower and upper parameter bounds.}

\item{collect_all}{[\code{logical(1)}]\cr
Keep every converged local optimum even if it is inferior to the best known
solution and disable early stopping?}

\item{quiet}{[\code{logical(1)}]\cr
Suppress messages?}
}
\value{
A \code{data.frame} summarizing the identified optima or \code{NULL} if none
could be determined.
}
\description{
This function performs variable neighborhood trust region search.
}
\examples{
rosenbrock <- function(x) 100 * (x[2] - x[1]^2)^2 + (1 - x[1])^2
vntrs(f = rosenbrock, npar = 2)
}
\references{
Bierlaire et al. (2009) "A Heuristic for Nonlinear Global Optimization"
\doi{10.1287/ijoc.1090.0343}.
}
