% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getComponents.R
\name{getComponents}
\alias{getComponents}
\title{Get Components Name and Positions}
\usage{
getComponents(fileNames, fileNamePattern = "ID_Condition_Dimension", sep = "_")
}
\arguments{
\item{fileNames}{A character vector of audio file names.}

\item{fileNamePattern}{A character string indicating the naming format of the audio files, such as "ID-Condition-Dimension", "Condition_ID_Dimension" or "ID". Default corresponds to "ID_Condition_Dimension".}

\item{sep}{A non alpha-numeric that acts as separator between the different naming components. Default corresponds to underscore.}
}
\value{
A list, containing a vector of positions for each component and a data.frame containing the values for each component of the audio files.
}
\description{
Indicates the presence and order in which components are retrieved from the file name of each recording.
}
\examples{
getComponents(names(testAudioList), fileNamePattern = "ID_Condition_", sep = "_")

}
