% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_shortCallCondorPnL.R
\name{shortCallCondorPnL}
\alias{shortCallCondorPnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Short Call Condor Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
shortCallCondorPnL(
  ST,
  X1L,
  X2Ml,
  X3Mu,
  X4H,
  C1L,
  C2Ml,
  C3Mu,
  C4H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price for one ITM shorted Call.}

\item{X2Ml}{Middle-low Strike Price or eXercise price for two middle strike bought Calls.}

\item{X3Mu}{Middle-upper Strike Price or eXercise price for two middle strike bought Calls.}

\item{X4H}{Higher Strike Price or eXercise price for one OTM shorted Call.}

\item{C1L}{Call Premium or Call Price received for the one ITM shorted Call.}

\item{C2Ml}{Call Premium or Call Price paid for the middle-low bought Call.}

\item{C3Mu}{Call Premium or Call Price paid for the middle-upper bought Call.}

\item{C4H}{Call Premium or Call Price received for the one OTM shorted Call.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This is a volatility strategy consisting of a short position in an ITM call option with a strike price X1L, a long position in an ITM call option with a higher strike price X2Ml, a long position in an OTM call option with a strike price X3Mu, and a short position in an OTM call option with a higher strike price X4H. All strikes are equidistant: X4H minus X3Mu equals to X3Mu minus X2Ml; equals to X2Mu minus X1L. This is a relatively low net credit trade. The trader or investor has a neutral  outlook (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Short Call Condor Option Strategy and draw its graph in the Plots tab.
}
\examples{
shortCallCondorPnL(52,45,50,55,60,10,7,4,3.)
shortCallCondorPnL(415,400,420,440,460,50,35,22,16,hl=0.95,hu=1.125)
}
