% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Authenticate.mastodon.R
\name{Authenticate.mastodon}
\alias{Authenticate.mastodon}
\title{Mastodon API authentication}
\usage{
\method{Authenticate}{mastodon}(
  socialmedia,
  instance = NULL,
  type = "public",
  ...,
  verbose = TRUE
)
}
\arguments{
\item{socialmedia}{Character string. Identifier for social media API to authenticate, set to \code{"mastodon"}.}

\item{instance}{Character string. Server to authenticate against and create token.}

\item{type}{Character string. Type of access, can be \code{"public"} or \code{"user"}. Default is \code{"public"}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
A \code{credential} object containing an access token \code{$auth} and social media type descriptor
\code{$socialmedia} set to \code{"mastodon"}. Object has the class names \code{"credential"} and \code{"mastodon"}.
}
\description{
Mastodon OAuth authentication.
}
\note{
\pkg{vosonSML} uses the \pkg{rtoot} package for Mastodon data collection and API access tokens.
}
\examples{
\dontrun{
# mastodon API public access bearer token
mastodon_auth <- Authenticate(
  "mastodon",
  instance = "mastodon.social"
)

# mastodon API user access bearer token
mastodon_auth_user <- Authenticate(
  "mastodon",
  instance = "mastodon.social",
  type = "user"
)

# if thread collection API token not required
mastodon_auth <- Authenticate("mastodon")
}

}
