% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.R
\name{vsts_run_command}
\alias{vsts_run_command}
\title{Azure DevOps Custom API Calls}
\usage{
vsts_run_command(url, verb, auth_key, body = NULL, query = NULL)
}
\arguments{
\item{url}{the URI of the API call to run}

\item{verb}{name of the verb to use}

\item{auth_key}{authentication key generated by using \code{\link{vsts_auth_key}}}

\item{body}{check \code{\link[httr]{VERB}} for more details. If the object is a named list, then it will be
transformed into a JSON string so that can be added to the call. Use
\url{https://docs.microsoft.com/en-us/rest/api/azure/devops} to find out any required parameter for the body.}

\item{query}{a list of extra parameters that can be sent to the API call. If not required then leave as \code{NULL}}
}
\description{
For any requirement not currently in place in the \code{vstsr} package, then this function will allow you
to use the relevant API call without any extra requirements.

For the most part it is just a shell of \code{\link[httr]{VERB}} but will have the \code{auth_key} set up already.
}
\examples{
\dontrun{
auth_key <- vsts_auth_key("<username>", "<password>")
# Get commits of a repository
URL <- file.path(
  "https://dev.azure.com",
  domain,
  project,
  "_apis/git/repositories",
  repository_id,
  "commits?api-version=5.0"
)
vsts_run_command(URL, "GET", auth_key)
}

}
