% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_timetable_staff.R
\name{get_timetable_staff}
\alias{get_timetable_staff}
\title{Retrieve timetable data for a specific staff member from the Semestry API}
\usage{
get_timetable_staff(
  semestry,
  staff_code,
  start = NULL,
  end = NULL,
  timeout = 30
)
}
\arguments{
\item{semestry}{An authenticated Semestry object.}

\item{staff_code}{The staff code to retrieve timetable data for.}

\item{start}{Optional start date in YYYY-MM-DD format (10 characters).}

\item{end}{Optional end date in YYYY-MM-DD format (10 characters).}

\item{timeout}{The timeout duration for the GET request (default: 30 seconds).}
}
\value{
The retrieved timetable data for the specified staff member from the API.
}
\description{
This function sends a GET request to the timetable staff endpoint of the Semestry API and retrieves the timetable data for a specific staff member.
}
