\name{grid.brushXspline}
\alias{grid.brushXspline}
\alias{brushXsplineGrob}
\alias{verticalBrush}
\alias{circleBrush}
\alias{squareBrush}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Sweep an X-spline curve with a brush.
}
\description{
  Sweep an X-spline curve with a brush; the main curve is described
  by x/y control points and a variable-size brush is used to sweep a
  variable-width line from the main curve.
}
\usage{
brushXsplineGrob(brush, x, y, w=unit(1, "cm"), default.units="npc",
                 shape=1, angle="perp", open=TRUE, spacing=NULL,
                 render=vwPath(),
                 gp=gpar(fill="black"), name=NULL, debug=FALSE)
grid.brushXspline(...)

verticalBrush
circleBrush(n=50)
squareBrush
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{brush}{A description of a brush shape (see Details).  Some
    simple brushes are provided by \code{verticalBrush} and \code{circleBrush}.}
  \item{x}{A numeric vector or unit describing x-locations.}
  \item{y}{A numeric vector or unit describing y-locations.}
  \item{w}{A numeric vector or unit describing widths at each location,
    or a width specification generated by \code{\link{widthSpec}}.}
  \item{default.units}{The units used if \code{x} or \code{y} are
    numeric vectors.}
  \item{shape}{A numeric value (or one per location) that controls
    the shape of the X-spline curve relative to the locations.}
  \item{angle}{Either \code{"perp"} or a numeric value describing a
    fixed orientation for the line width.}
  \item{open}{A boolean indicating whether to connect the last location
    back to the first location to produce a closed line.}
  \item{spacing}{A numeric vector or unit describing where the brush
    will be placed along the main curve.}
  \item{render}{A function that is used to render the outline of the path
    that is generated for the variable-width line.}
  \item{gp}{A set of graphical parameters; see \code{\link{gpar}}.}
  \item{name}{A name for the grob generated for the variable-width
    line.}
  \item{debug}{A logical indicating whether to produce graphical
    debugging output.}
  \item{\dots}{
    Arguments passed to \code{brushXsplineGrob}.
  }
  \item{n}{Number of points to generate on circumference of circle brush.}
}
\details{
  The brush is described using a list with components \code{x} and
  \code{y}. The brush is described in a coordinate system [-1, 1] (in
  both \code{x} and \code{y}).  The predefined brushes are
  \code{verticalBrush} (thin vertical line), \code{circleBrush} (the number
  of points on the circumference can be controlled), and \code{squareBrush}.

  By default, the brush is placed at (almost) all points along the main
  curve.  If \code{spacing} is specified, then the brush is only placed
  at those locations on the main curve.  If \code{spacing} is a
  numeric vector, the values are
  assumed to be proportions of the length of the main curve.  The
  spacing is automatically recycled to the cover the full length of the
  main curve.
  
  See \code{\link{grid.xspline}} for more about the behaviour of X-splines.
}
\value{
  \code{grid.brushXspline} is used for its side-effect of drawing a
  variable-width
  line;  \code{brushXsplineGrob} returns a \code{"brushXsplineGrob"} object.
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{grid.xspline}},
  \code{\link{grid.vwline}},
  \code{\link{grid.vwcurve}},
  \code{\link{grid.offsetXspline}},
  \code{\link{grid.vwXspline}}
}
\examples{
grid.newpage()
x <- c(.2, .4, .6, .8)
y <- c(-.05, .05, -.05, .05)
w <- unit(c(2, 4, 6, 8), "mm")
grid.brushXspline(verticalBrush, x, y + .8, w)
grid.brushXspline(verticalBrush, x, y + .6, w,
                  shape=-1)
grid.brushXspline(circleBrush(), x, y + .4, w)
grid.brushXspline(verticalBrush, x, y + .2, w,
                  gp=gpar(col="black"), debug=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ aplot }% use one of  RShowDoc("KEYWORDS")
