% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{Print}
\alias{Print}
\alias{printf}
\alias{logger}
\alias{fprintf}
\title{Printing}
\usage{
printf(fmt, ...)

logger(fmt, ..., dt_fmt = "\%Y-\%m-\%d \%H:\%M:\%S", join = " - ")

fprintf(file, fmt, ...)
}
\arguments{
\item{fmt}{Format string which can be processed by \code{sprintf}}

\item{...}{Additional arguments}

\item{dt_fmt}{Format string which can be processed by \code{format.POSIXct}}

\item{join}{A string to place between the timestamp and the message.}

\item{file}{A connection, or a character string naming the file to print to}
}
\value{
None (invisible \code{NULL}); functions are called for side effects.
}
\description{
Functions to print messages using an \code{sprintf} syntax.
}
\examples{
printf("Hello world \%f \%d\n", 0.1, 5)
logger("Hello world\n")
logger("Hello world \%f \%d\n", 0.1, 5)
logger("Hello world \%f \%d\n", 0.1, 5, dt_fmt = "\%H:\%M:\%S")
logger("Hello world \%f \%d\n", 0.1, 5, join = " >> ")
logger("Hello world \%f \%d\n", 0.1, 5, join = " ")

}
