% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waiter.R
\name{autoWaiter}
\alias{autoWaiter}
\title{Automatic Waiter}
\usage{
autoWaiter(id = NULL, html = NULL, color = NULL, image = "", fadeout = FALSE)
}
\arguments{
\item{id}{Vector of ids of elements to overlay the waiter.
If `NULL` then the loading screens are applied to all
elements.}

\item{html}{HTML content of waiter, generally a spinner, see \code{\link{spinners}}.}

\item{color}{Background color of loading screen.}

\item{image}{Path to background image.}

\item{fadeout}{Use a fade out effect when the screen is removed.
Can be a boolean, or a numeric indicating the number of 
milliseconds the effect should take.}
}
\description{
This function allows easily adding
waiters to dynamically rendered Shiny content where
"dynamic" means `render*` and `*output` function pair.
}
\details{
This will display the waiter when the element is being 
recalculated and hide it when it receives new data.
}
\examples{
library(shiny)
library(waiter)

ui <- fluidPage(
	autoWaiter(),
	actionButton(
		"trigger",
		"Render"
	),
	plotOutput("plot"),
	plotOutput("dom")
)

server <- function(input, output){
	output$plot <- renderPlot({
		input$trigger
		Sys.sleep(3)
		plot(cars)
	})

	output$dom <- renderPlot({
		input$trigger
		Sys.sleep(5)
		plot(runif(100))
	})
}

if(interactive())
 shinyApp(ui, server)

}
