% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_inclusive.R
\name{sex_inclusive}
\alias{sex_inclusive}
\alias{gender_inclusive}
\title{Generate Random Vector of Non-Binary Genders}
\usage{
sex_inclusive(
  n,
  x = c("Male", "Female", "Intersex"),
  prob = NULL,
  name = "Sex"
)

gender_inclusive(
  n,
  x = c("Male", "Female", "Trans*"),
  prob = NULL,
  name = "Gender"
)
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of sex or gender elements.
}
\description{
Generate a random vector of non-binary genders. Proportion of trans*
category was taken from the
\href{https://williamsinstitute.law.ucla.edu/}{Williams Institute Report} (2011),
and subtracted equally from the male and female categories.
}
\details{
The genders and probabilities used match approximate gender
make-up:

\tabular{lr}{
  \bold{Gender}     \tab \bold{Percent}\cr
  Male    \tab 51.07 \%\cr
  Female  \tab 48.63 \%\cr
  Trans*  \tab 0.30 \%\cr
}
}
\examples{
sex_inclusive(10)
barplot(table(sex_inclusive(10000)))

gender_inclusive(10)
barplot(table(gender_inclusive(10000)))
}
\seealso{
Other variable functions: 
\code{\link{age}()},
\code{\link{animal}()},
\code{\link{answer}()},
\code{\link{area}()},
\code{\link{car}()},
\code{\link{children}()},
\code{\link{coin}()},
\code{\link{color}},
\code{\link{date_stamp}()},
\code{\link{death}()},
\code{\link{dice}()},
\code{\link{dna}()},
\code{\link{dob}()},
\code{\link{dummy}()},
\code{\link{education}()},
\code{\link{employment}()},
\code{\link{eye}()},
\code{\link{grade_level}()},
\code{\link{grade}()},
\code{\link{group}()},
\code{\link{hair}()},
\code{\link{height}()},
\code{\link{income}()},
\code{\link{internet_browser}()},
\code{\link{iq}()},
\code{\link{language}},
\code{\link{level}()},
\code{\link{likert}()},
\code{\link{lorem_ipsum}()},
\code{\link{marital}()},
\code{\link{military}()},
\code{\link{month}()},
\code{\link{name}},
\code{\link{normal}()},
\code{\link{political}()},
\code{\link{race}()},
\code{\link{religion}()},
\code{\link{sat}()},
\code{\link{sentence}()},
\code{\link{sex}()},
\code{\link{smokes}()},
\code{\link{speed}()},
\code{\link{state}()},
\code{\link{string}()},
\code{\link{upper}()},
\code{\link{valid}()},
\code{\link{year}()},
\code{\link{zip_code}()}
}
\author{
Matthew Sigal <msigal@yorku.ca>
}
\concept{variable functions}
\keyword{gender}
\keyword{sex}
