% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_results}
\alias{summarize_results}
\title{Summarize Results}
\usage{
summarize_results(
  df,
  vars,
  weight_col = NULL,
  id_col = 1,
  strata_col = NULL,
  label = NULL
)
}
\arguments{
\item{df}{data.frame with sample and weights (if using a survey design)}

\item{vars}{string vector of variables to calculate prevalences for}

\item{weight_col}{string specifying the column with weights or NULL for unweighted}

\item{id_col}{string specifying the column with IDs for cluster-aware standard error (SE) calculations}

\item{strata_col}{string specifying the column with strata for cluster-aware SE calculations}

\item{label}{string label for weighting method}
}
\value{
data.frame with totals, means, and standard errors (if using a survey design)
}
\description{
Get adjusted totals and prevalence for provided variables.
}
\examples{
# Prepare the NHIS data
calVars <- c(
  "SEX_A_R", "AGEP_A_R", "HISPALLP_A_R", "ORIENT_A_R", "HICOV_A_R", "EDUCP_A_R", "REGION_R",
  "EMPLASTWK_A_R", "HOUTENURE_A_R", "MARITAL_A_R"
)
stuVars <- "DIBTYPE_A_R"
vars_dummies <- c("AGEP_A_R","HISPALLP_A_R","EDUCP_A_R","REGION_R")
nhis_keep_vars <- c("PPSU","PSTRAT","WTFA_A")
nhis_imputed <- impute_data(nhis_processed, c(calVars, stuVars), nhis_keep_vars)
nhis_dummied <- dummies(nhis_imputed, vars=paste0(vars_dummies, '_I'))
factor_vars <- setdiff(names(nhis_dummied), nhis_keep_vars)
nhis_dummied[factor_vars] <- lapply(nhis_dummied[factor_vars], as.factor)

# Prepare the synthetic All of Us data
aou_imputed <- impute_data(aou_synthetic, c(calVars, stuVars))
aou_dummied <- dummies(aou_imputed, vars=paste0(vars_dummies, '_I'))
aou_dummied[] <- lapply(aou_dummied, as.factor)

# Calculate IPW weights using NHIS data and applied to All of Us
weights_df <- calculate_weights(
  nhis_dummied, 
  nhis_dummied, 
  'ipw',
  paste0(calVars, '_I'), 
  paste0(stuVars, '_I'), 
  weight='WTFA_A',
  strata='PSTRAT',
  psu='PPSU'
)

results_ipw <- summarize_results(
  weights_df,
  c(paste0(calVars, '_I'), paste0(stuVars, '_I')), 
  weight_col='ipw_weight', 
  label='AoU: IPW'
)

}
