% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_description.R
\name{update_description}
\alias{update_description}
\title{Update the DESCRIPTION file to conform with openwashdata standards}
\usage{
update_description(
  file = ".",
  github_user = "https://github.com/openwashdata/"
)
}
\arguments{
\item{file}{Character. The file path to the DESCRIPTION file of the R package. Defaults to the current working directory.}

\item{github_user}{Character. The URL path to the GitHub user or organization that hosts the current package. Defaults to "https://github.com/openwashdata".}
}
\value{
NULL. Update fields directly in DESCRIPTION file.
}
\description{
This function updates the DESCRIPTION file of an R package to comply with openwashdata standards.
It ensures that fields such as \code{License}, \code{Language}, \code{Date}, \code{URL}, and others are correctly specified.
}
\examples{
\dontrun{
 # Update DESCRIPTION file in the current package
update_description()

 # Update DESCRIPTION file in a specific package
update_description(file = "path/to/your/package/DESCRIPTION")

 # Update DESCRIPTION file with a specific GitHub user
update_description(github_user = "https://github.com/yourusername")
}


}
