% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_wbb_data.R
\name{espn_wbb_team_stats}
\alias{espn_wbb_team_stats}
\title{\strong{Get ESPN women's college basketball team stats data}}
\usage{
espn_wbb_team_stats(team_id, year, season_type = "regular", total = FALSE)
}
\arguments{
\item{team_id}{Team ID}

\item{year}{Year}

\item{season_type}{(character, default: regular): Season type - regular or postseason}

\item{total}{(boolean, default: FALSE): Totals}
}
\value{
Returns a tibble with the team stats data\tabular{ll}{
   col_name \tab types \cr
   team_id \tab integer \cr
   team_guid \tab character \cr
   team_uid \tab character \cr
   team_sdr \tab integer \cr
   team_slug \tab character \cr
   team_location \tab character \cr
   team_name \tab character \cr
   team_nickname \tab character \cr
   team_abbreviation \tab character \cr
   team_display_name \tab character \cr
   team_short_display_name \tab character \cr
   team_color \tab character \cr
   team_alternate_color \tab character \cr
   team_is_active \tab logical \cr
   team_is_all_star \tab logical \cr
   logo_href \tab character \cr
   logo_dark_href \tab character \cr
   defensive_blocks \tab numeric \cr
   defensive_defensive_rebounds \tab numeric \cr
   defensive_steals \tab numeric \cr
   defensive_turnover_points \tab numeric \cr
   defensive_avg_defensive_rebounds \tab numeric \cr
   defensive_avg_blocks \tab numeric \cr
   defensive_avg_steals \tab numeric \cr
   general_disqualifications \tab numeric \cr
   general_flagrant_fouls \tab numeric \cr
   general_fouls \tab numeric \cr
   general_ejections \tab numeric \cr
   general_technical_fouls \tab numeric \cr
   general_rebounds \tab numeric \cr
   general_minutes \tab numeric \cr
   general_avg_minutes \tab numeric \cr
   general_fantasy_rating \tab numeric \cr
   general_avg_rebounds \tab numeric \cr
   general_avg_fouls \tab numeric \cr
   general_avg_flagrant_fouls \tab numeric \cr
   general_avg_technical_fouls \tab numeric \cr
   general_avg_ejections \tab numeric \cr
   general_avg_disqualifications \tab numeric \cr
   general_assist_turnover_ratio \tab numeric \cr
   general_steal_foul_ratio \tab numeric \cr
   general_block_foul_ratio \tab numeric \cr
   general_avg_team_rebounds \tab numeric \cr
   general_total_rebounds \tab numeric \cr
   general_total_technical_fouls \tab numeric \cr
   general_team_assist_turnover_ratio \tab numeric \cr
   general_team_rebounds \tab numeric \cr
   general_steal_turnover_ratio \tab numeric \cr
   general_games_played \tab numeric \cr
   general_games_started \tab numeric \cr
   general_double_double \tab numeric \cr
   general_triple_double \tab numeric \cr
   offensive_assists \tab numeric \cr
   offensive_field_goals \tab numeric \cr
   offensive_field_goals_attempted \tab numeric \cr
   offensive_field_goals_made \tab numeric \cr
   offensive_field_goal_pct \tab numeric \cr
   offensive_free_throws \tab numeric \cr
   offensive_free_throw_pct \tab numeric \cr
   offensive_free_throws_attempted \tab numeric \cr
   offensive_free_throws_made \tab numeric \cr
   offensive_offensive_rebounds \tab numeric \cr
   offensive_points \tab numeric \cr
   offensive_turnovers \tab numeric \cr
   offensive_three_point_field_goals_attempted \tab numeric \cr
   offensive_three_point_field_goals_made \tab numeric \cr
   offensive_team_turnovers \tab numeric \cr
   offensive_total_turnovers \tab numeric \cr
   offensive_fast_break_points \tab numeric \cr
   offensive_avg_field_goals_made \tab numeric \cr
   offensive_avg_field_goals_attempted \tab numeric \cr
   offensive_avg_three_point_field_goals_made \tab numeric \cr
   offensive_avg_three_point_field_goals_attempted \tab numeric \cr
   offensive_avg_free_throws_made \tab numeric \cr
   offensive_avg_free_throws_attempted \tab numeric \cr
   offensive_avg_points \tab numeric \cr
   offensive_avg_offensive_rebounds \tab numeric \cr
   offensive_avg_assists \tab numeric \cr
   offensive_avg_turnovers \tab numeric \cr
   offensive_offensive_rebound_pct \tab numeric \cr
   offensive_estimated_possessions \tab numeric \cr
   offensive_avg_estimated_possessions \tab numeric \cr
   offensive_points_per_estimated_possessions \tab numeric \cr
   offensive_avg_team_turnovers \tab numeric \cr
   offensive_avg_total_turnovers \tab numeric \cr
   offensive_three_point_field_goal_pct \tab numeric \cr
   offensive_two_point_field_goals_made \tab numeric \cr
   offensive_two_point_field_goals_attempted \tab numeric \cr
   offensive_avg_two_point_field_goals_made \tab numeric \cr
   offensive_avg_two_point_field_goals_attempted \tab numeric \cr
   offensive_two_point_field_goal_pct \tab numeric \cr
   offensive_shooting_efficiency \tab numeric \cr
   offensive_scoring_efficiency \tab numeric \cr
}
}
\description{
\strong{Get ESPN women's college basketball team stats data}
}
\examples{
\donttest{
  try(espn_wbb_team_stats(team_id = 52, year = 2020))
}
}
\seealso{
Other ESPN WBB Functions: 
\code{\link{espn_wbb_conferences}()},
\code{\link{espn_wbb_game_all}()},
\code{\link{espn_wbb_game_rosters}()},
\code{\link{espn_wbb_pbp}()},
\code{\link{espn_wbb_player_box}()},
\code{\link{espn_wbb_player_stats}()},
\code{\link{espn_wbb_rankings}()},
\code{\link{espn_wbb_scoreboard}()},
\code{\link{espn_wbb_standings}()},
\code{\link{espn_wbb_team_box}()},
\code{\link{espn_wbb_teams}()}
}
\author{
Saiem Gilani
}
\concept{ESPN WBB Functions}
\keyword{Stats}
\keyword{Team}
\keyword{WBB}
