% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playerawards}
\alias{wnba_playerawards}
\title{\strong{Get WNBA Stats API Player Awards}}
\usage{
wnba_playerawards(player_id, ...)
}
\arguments{
\item{player_id}{Player ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PlayerAwards

\strong{PlayerAwards}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   FIRST_NAME \tab character \cr
   LAST_NAME \tab character \cr
   TEAM \tab character \cr
   DESCRIPTION \tab character \cr
   ALL_WNBA_TEAM_NUMBER \tab character \cr
   SEASON \tab character \cr
   MONTH \tab character \cr
   WEEK \tab character \cr
   CONFERENCE \tab character \cr
   TYPE \tab character \cr
   SUBTYPE1 \tab character \cr
   SUBTYPE2 \tab character \cr
   SUBTYPE3 \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player Awards}

\strong{Get WNBA Stats API Player Awards}
}
\details{
\href{https://stats.wnba.com/player/1628932/career/}{Player Awards}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_playerawards(player_id = '1628932')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Player Functions}
