% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playerfantasyprofile}
\alias{wnba_playerfantasyprofile}
\title{\strong{Get WNBA Stats API Player Fantasy Profile}}
\usage{
wnba_playerfantasyprofile(
  league_id = "10",
  measure_type = "Base",
  pace_adjust = "N",
  per_mode = "Totals",
  player_id = "1628932",
  plus_minus = "N",
  rank = "N",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{measure_type}{measure_type}

\item{pace_adjust}{Pace Adjustment - Y/N}

\item{per_mode}{Per Mode - PerGame, Totals}

\item{player_id}{Player ID}

\item{plus_minus}{Plus Minus - Y/N}

\item{rank}{Rank - Y/N}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: DaysRestModified, LastNGames, Location, Opponent, Overall

\strong{Overall}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   DD2 \tab character \cr
   TD3 \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
}


\strong{Location}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   DD2 \tab character \cr
   TD3 \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
}


\strong{LastNGames}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   DD2 \tab character \cr
   TD3 \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
}


\strong{DaysRestModified}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   SEASON_YEAR \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   DD2 \tab character \cr
   TD3 \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   WNBA_FANTASY_PTS \tab character \cr
}


\strong{Opponent}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   GROUP_VALUE \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   DD2 \tab character \cr
   TD3 \tab character \cr
   FAN_DUEL_PTS \tab character \cr
   NBA_FANTASY_PTS \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player Fantasy Profile}

\strong{Get WNBA Stats API Player Fantasy Profile}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_playerfantasyprofile(player_id = '1628932')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}

Other WNBA Fantasy Functions: 
\code{\link{wnba_fantasywidget}()},
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_playerfantasyprofilebargraph}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Fantasy Functions}
\concept{WNBA Player Functions}
