% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playerindex}
\alias{wnba_playerindex}
\title{\strong{Get WNBA Stats API Player Index}}
\usage{
wnba_playerindex(
  college = "",
  country = "",
  draft_pick = "",
  draft_round = "",
  draft_year = "",
  height = "",
  historical = 1,
  league_id = "10",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  team_id = "0",
  weight = "",
  ...
)
}
\arguments{
\item{college}{Player College}

\item{country}{Player Country}

\item{draft_pick}{Draft Pick}

\item{draft_round}{Draft Round}

\item{draft_year}{Draft Year}

\item{height}{Player Height}

\item{historical}{Whether to include only current players (0) or all historical (1).}

\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{team_id}{Team ID. Default: 0 (all teams).}

\item{weight}{Player weight}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PlayerIndex

\strong{PlayerIndex}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   PLAYER_LAST_NAME \tab character \cr
   PLAYER_FIRST_NAME \tab character \cr
   PLAYER_SLUG \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_SLUG \tab character \cr
   IS_DEFUNCT \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   JERSEY_NUMBER \tab character \cr
   POSITION \tab character \cr
   HEIGHT \tab character \cr
   WEIGHT \tab character \cr
   COLLEGE \tab character \cr
   COUNTRY \tab character \cr
   DRAFT_YEAR \tab character \cr
   DRAFT_ROUND \tab character \cr
   DRAFT_NUMBER \tab character \cr
   ROSTER_STATUS \tab character \cr
   PTS \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STATS_TIMEFRAME \tab character \cr
   FROM_YEAR \tab character \cr
   TO_YEAR \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player Index}

\strong{Get WNBA Stats API Player Index}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_playerindex()
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Player Functions}
