% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_method.R
\encoding{UTF-8}
\name{delta_method}
\alias{delta_method}
\title{Delta Method for Parametric Lifetime Distributions}
\usage{
delta_method(
  x,
  dist_params,
  dist_varcov,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2"),
  direction = c("y", "x"),
  p = deprecated()
)
}
\arguments{
\item{x}{A numeric vector of probabilities or quantiles. If the standard errors
of quantiles should be determined the corresponding probabilities have to be
specified, and if the standard errors of standardized quantiles (z-values)
should be computed corresponding quantiles are required.}

\item{dist_params}{The parameters (\code{coefficients}) returned by \link{ml_estimation}.}

\item{dist_varcov}{The variance-covariance-matrix (\code{varcov}) returned by
\link{ml_estimation}.}

\item{distribution}{Supposed distribution of the random variable. Has to be in
line with the specification made in \link{ml_estimation}.}

\item{direction}{A character string specifying for which quantity the standard
errors are calculated. \code{"y"} if \code{x} are quantiles or \code{"x"} if \code{x} are probabilities.}

\item{p}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}: Use \code{x} instead.}
}
\value{
A numeric vector of estimated standard errors for quantiles or
standardized quantiles (\emph{z-values}).
}
\description{
This function applies the \emph{delta method} to a parametric lifetime distribution.
}
\details{
The delta method estimates the standard errors for quantities that can be
written as non-linear functions of ML estimators. Hence, the parameters as
well as the variance-covariance matrix of these quantities have to be estimated
with \link[=ml_estimation]{maximum likelihood}.

The estimated standard errors are used to calculate Fisher's (normal
approximation) confidence intervals. For confidence bounds on the probability,
standard errors of the standardized quantiles (\code{direction = "y"}) have to be
computed (\emph{z-procedure}) and for bounds on quantiles, standard errors of
quantiles (\code{direction = "x"}) are required. For more information see
\link{confint_fisher}.
}
\examples{
# Reliability data preparation:
data <- reliability_data(
  shock,
  x = distance,
  status = status
)

# Parameter estimation using maximum likelihood:
mle <- ml_estimation(
  data,
  distribution = "weibull",
  conf_level = 0.95
)

# Example 1 - Standard errors of standardized quantiles:
delta_y <- delta_method(
  x = shock$distance,
  dist_params = mle$coefficients,
  dist_varcov = mle$varcov,
  distribution = "weibull",
  direction = "y"
)

# Example 2 - Standard errors of quantiles:
delta_x <- delta_method(
  x = seq(0.01, 0.99, 0.01),
  dist_params = mle$coefficients,
  dist_varcov = mle$varcov,
  distribution = "weibull",
  direction = "x"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
