% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_estimation.R
\name{ml_estimation.default}
\alias{ml_estimation.default}
\title{ML Estimation for Parametric Lifetime Distributions}
\usage{
\method{ml_estimation}{default}(
  x,
  status,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2"),
  wts = rep(1, length(x)),
  conf_level = 0.95,
  start_dist_params = NULL,
  control = list(),
  ...
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime data
could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{status}{A vector of binary data (0 or 1) indicating whether a unit is
a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{Supposed distribution of the random variable.}

\item{wts}{Optional vector of case weights. The length of \code{wts} must be equal
to the number of observations in \code{x}.}

\item{conf_level}{Confidence level of the interval.}

\item{start_dist_params}{Optional vector with initial values of the
(log-)location-scale parameters.}

\item{control}{A list of control parameters (see 'Details' and
\link[stats:optim]{optim}).}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A list with classes \code{wt_model}, \code{wt_ml_estimation} and \code{wt_model_estimation}
which contains:
\itemize{
\item \code{coefficients} : A named vector of estimated coefficients (parameters of the
assumed distribution). \strong{Note}: The parameters are given in the
(log-)location-scale-parameterization.
\item \code{confint} : Confidence intervals for the (log-)location-scale parameters.
\item \code{shape_scale_coefficients} : Only included if \code{distribution} is \code{"weibull"}
or \code{"weibull3"} (parameterization used in \link[stats:Weibull]{Weibull}).
\item \code{shape_scale_confint} : Only included if \code{distribution} is \code{"weibull"}
or \code{"weibull3"}. Confidence intervals for scale \eqn{\eta} and shape \eqn{\beta}
(and threshold \eqn{\gamma} if \code{distribution = "weibull3"}).
\item \code{varcov} : Estimated variance-covariance matrix of (log-)location-scale parameters.
\item \code{logL} : The log-likelihood value.
\item \code{aic} : Akaike Information Criterion.
\item \code{bic} : Bayesian Information Criterion.
\item \code{data} : A \code{tibble} with columns \code{x} and \code{status}.
\item \code{distribution} : Specified distribution.
}
}
\description{
This function estimates the parameters of a parametric lifetime distribution
for complete and (multiple) right-censored data. The parameters
are determined in the frequently used (log-)location-scale parameterization.

For the Weibull, estimates are additionally transformed such that they are in
line with the parameterization provided by the \emph{stats} package
(see \link[stats:Weibull]{Weibull}).
}
\details{
Within \code{ml_estimation}, \link[stats:optim]{optim} is called with \code{method = "BFGS"}
and \code{control$fnscale = -1} to estimate the parameters that maximize the
log-likelihood (see \link{loglik_function}). For threshold models, the profile
log-likelihood is maximized in advance (see \link{loglik_profiling}). Once the
threshold parameter is determined, the threshold model is treated like a
distribution without threshold (lifetime is reduced by threshold estimate)
and the general optimization routine is applied.

Normal approximation confidence intervals for the parameters are computed as well.
}
\examples{
# Vectors:
obs <- seq(10000, 100000, 10000)
status_1 <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

cycles <- alloy$cycles
status_2 <- alloy$status

# Example 1 - Fitting a two-parametric weibull distribution:
ml <- ml_estimation(
  x = obs,
  status = status_1,
  distribution = "weibull",
  conf_level = 0.90
)

# Example 2 - Fitting a three-parametric lognormal distribution:
ml_2 <- ml_estimation(
  x = cycles,
  status = status_2,
  distribution = "lognormal3"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
\seealso{
\link{ml_estimation}
}
