% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_prob.default}
\alias{plot_prob.default}
\title{Probability Plotting Method for Univariate Lifetime Distributions}
\usage{
\method{plot_prob}{default}(
  x,
  y,
  status,
  id = rep("XXXXXX", length(x)),
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "exponential"),
  title_main = "Probability Plot",
  title_x = "Characteristic",
  title_y = "Unreliability",
  title_trace = "Sample",
  plot_method = c("plotly", "ggplot2"),
  ...
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime data
could be every characteristic influencing the reliability of a product, e.g.
operating time (days/months in service), mileage (km, miles), load cycles.}

\item{y}{A numeric vector which consists of estimated failure probabilities
regarding the lifetime data in \code{x}.}

\item{status}{A vector of binary data (0 or 1) indicating whether a unit is a
right censored observation (= 0) or a failure (= 1).}

\item{id}{Identification for every unit.}

\item{distribution}{Supposed distribution of the random variable.}

\item{title_main}{A character string which is assigned to the main title.}

\item{title_x}{A character string which is assigned to the title of the x axis.}

\item{title_y}{A character string which is assigned to the title of the y axis.}

\item{title_trace}{A character string which is assigned to the legend trace.}

\item{plot_method}{Package, which is used for generating the plot output.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A plot object containing the probability plot.
}
\description{
This function is used to apply the graphical technique of probability
plotting.
}
\details{
For \code{plot_method == "plotly"} the marker label for x and y are determined by
the first word provided in the argument \code{title_x} and \code{title_y} respectively,
i.e. if \code{title_x = "Mileage in km"} the x label of the marker is "Mileage".
}
\examples{
# Vectors:
cycles   <- alloy$cycles
status <- alloy$status

# Probability estimation:
prob_tbl <- estimate_cdf(
  x = cycles,
  status = status,
  method = "johnson"
)

# Example 1: Probability Plot Weibull:
plot_weibull <- plot_prob(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  id = prob_tbl$id
)

# Example 2: Probability Plot Lognormal:
plot_lognormal <- plot_prob(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  id = prob_tbl$id,
  distribution = "lognormal"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
\seealso{
\link{plot_prob}
}
