% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_squared_function.R
\name{r_squared_profiling.default}
\alias{r_squared_profiling.default}
\title{R-Squared-Profile Function for Parametric Lifetime Distributions with Threshold}
\usage{
\method{r_squared_profiling}{default}(
  x,
  y,
  thres,
  distribution = c("weibull3", "lognormal3", "loglogistic3", "exponential2"),
  direction = c("x_on_y", "y_on_x"),
  ...
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime data
could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{y}{A numeric vector which consists of estimated failure probabilities
regarding the lifetime data in x.}

\item{thres}{A numeric value for the threshold parameter.}

\item{distribution}{Supposed parametric distribution of the random variable.}

\item{direction}{Direction of the dependence in the regression model.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
Returns the coefficient of determination with respect to the threshold
parameter \code{thres}.
}
\description{
This function evaluates the coefficient of determination with respect to a
given threshold parameter of a parametric lifetime distribution. In terms of
\emph{Rank Regression} this function can be optimized (\link[stats:optim]{optim}) to
estimate the threshold parameter.
}
\examples{
# Vectors:
cycles <- alloy$cycles
status <- alloy$status

# Probability estimation:
prob_tbl <- estimate_cdf(
  x = cycles,
  status = status,
  method = "johnson"
)

# Determining the optimal coefficient of determination:
## Range of threshold parameter must be smaller than the first failure:
threshold <- seq(
  0,
  min(cycles[status == 1]) - 0.1,
  length.out = 100
)

## Coefficient of determination with respect to threshold values:
profile_r2 <- r_squared_profiling(
  x = prob_tbl$x[prob_tbl$status == 1],
  y = prob_tbl$prob[prob_tbl$status == 1],
  thres = threshold,
  distribution = "weibull3"
)

## Threshold value (among the candidates) that maximizes the
## coefficient of determination:
threshold[which.max(profile_r2)]

## plot:
plot(
  threshold,
  profile_r2,
  type = "l"
)
abline(
  v = threshold[which.max(profile_r2)],
  h = max(profile_r2),
  col = "red"
)

}
\seealso{
\link{r_squared_profiling}
}
