% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{welo_plot}
\alias{welo_plot}
\title{Plot for WElo and Elo rates}
\usage{
welo_plot(x, players, rates = "WElo", SP = 1500, line_width = 1.5)
}
\arguments{
\item{x}{An object of class 'welo', obtained after running the \code{\link{welofit}} function}

\item{players}{A character vector including the players whose rates will be plotted.
The indication of the player has to be: 'Surname N.'. For instance, 'Roger Federer' will be
included in the 'players' vector as 'Federer R.'}

\item{rates}{\strong{optional} Rates to be plotted. Valid choices are 'WElo' (by default) and 'Elo'}

\item{SP}{\strong{optional}  Starting points from which the rates originate. By default, SP is 1500}

\item{line_width}{\strong{optional} Line width, by default it is 1.5}
}
\value{
A ggplot2 plot
}
\description{
Plots WElo and Elo rates.
}
\examples{
db<-tennis_data("2022","ATP") 
db_clean<-clean(db,MNM=5)
res_welo<-welofit(db_clean)
players<-c("Nadal R.","Djokovic N.","Berrettini M.","Sinner J.")
welo_plot(res_welo,players,rates="WElo",SP=1500,line_width=1.5)
}
