% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_trial.R
\name{create_prior}
\alias{create_prior}
\title{Create Prior Periods}
\usage{
create_prior(prior_periods, current_period)
}
\arguments{
\item{prior_periods}{A numeric value of length 1, or the character string "All"; number of previous periods to use
in the treatment assignment model. This is used to implement the stationary/non-stationary bandit.
For example, a non-stationary bandit assumes the true probability of success for each treatment changes over time, so to
account for that, not all prior data should be used when making decisions because it could be "out of date".}

\item{current_period}{The current period of the simulation. Defined by loop structure inside \code{\link[=run_mab_trial]{run_mab_trial()}}.}
}
\value{
Numeric vector containing the prior treatment periods to be used when aggregating
the results for the current treatment assignment period.
}
\description{
Used during \code{\link[=run_mab_trial]{run_mab_trial()}} to create a vector of prior periods dynamically based on the specified
number of prior periods.
}
\seealso{
\itemize{
\item \code{\link[=run_mab_trial]{run_mab_trial()}}
}
}
\keyword{internal}
