% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilcox.m.test.R
\name{Wilcox.m.test}
\alias{Wilcox.m.test}
\title{1-Sample  Wilcoxon Sign Rank Hypothesis Test for Medians}
\usage{
Wilcox.m.test(dat, m_h0, alpha = 0.05,
alternative=c('greater', 'lesser', 'noteq'), normal_approx=FALSE)
}
\arguments{
\item{dat}{data vector relating to the sample the user is
performing the hypothesis test for}

\item{m_h0}{The value of the median as specified by the null hypothesis H_0}

\item{alpha}{The significance level of the hypothesis test (default = 0.05)}

\item{alternative}{The sign of the alternative hypothesis.
e.g 'greater' - H_1:m>m_h0 , 'lesser' - H_1:m<m_h0, 'noteq' - H_1:m!=m_h0}

\item{normal_approx}{Should the normal approximation test be applied? (default = FALSE)}
}
\value{
Prints out the results of the tests, and returns 3 values- test statistic,
p-value, and the significance level of the test, alpha
}
\description{
This function allows the user to conduct the 1-Sample  Wilcoxon Sign Rank Hypothesis
Test for Medians using the probability values from the exact
distribution of W.
}
\details{
This hypothesis test allows breaking of ties, and the number of
ties broken is also reflected in the printed results.
}
\examples{
##Given some data: 3, 4, 7, 10, 4, 12, 1, 9, 2, 15
##If we want to test the hypotheses H_0: m=5 against H_1: m>5
##without using normal approximation:
vec = c(3, 4, 7, 10, 4, 12, 1, 9, 2, 15)
res = Wilcox.m.test(dat = vec, m_h0 = 5,
alternative = 'greater', normal_approx = FALSE)

##If we want to apply the normal approximation(Z-test), with the same hypotheses:
res = Wilcox.m.test(dat = vec, m_h0 = 5,
alternative = 'greater', normal_approx = TRUE)
}
\references{
Peter J. Bickel and Kjell A. Doksum (1973). \emph{Mathematical Statistics:
Basic Ideas and Selected Topics}. Prentice Hall.
}
\seealso{
\code{\link{wilcox.test}} for the same tests applied to 2 sample problems
but is not able to break ties
}
