% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_analysis_functions.R
\name{get_wl_metadata}
\alias{get_wl_metadata}
\title{Get file info for a sequence of experiment files}
\usage{
get_wl_metadata(file_path, pattern = "*.ddf")
}
\arguments{
\item{file_path}{Path where files are stored. Should be in the same folder.}

\item{pattern}{Regex pattern for identifying relevant files in the file_path.}
}
\value{
Either a \code{data.frame} (if a single file is supplied) or a
\code{list} of \code{data.frame}s (if a list of files is supplied), with
information as supplied from \code{file.info()}.
}
\description{
Grab metadata from files stored in the same folder (e.g. a sequence of trials
 in an experiment).
}
\details{
If several files (e.g. successive trials from one experiment) are
stored in one folder, use this function to obtain metadata in a list
format. Runs \code{file.info()} from base R to extract info from files.

This function is not truly considered to be part of the batch analysis
pipeline;
see \code{read_analyze_wl_dir()} for a similar function that not
only grabs metadata but also imports & analyzes files. Instead,
\code{get_wl_metadata()} is meant to be a handy function to investigate
metadata issues that arise if running \code{read_analyze_wl_dir()} goes awry.

Unlike \code{read_analyze_wl_dir()}, this function does not necessarily need
files to all be work loops. Any file type is welcome (as long as the Regex
\code{pattern} argument makes sense).
}
\examples{

library(workloopR)

# get file info for files included with workloopR
wl_meta <- get_wl_metadata(system.file("extdata/wl_duration_trials",
                                       package = 'workloopR'))

}
\seealso{
\code{\link{summarize_wl_trials}}

Other data import functions: 
\code{\link{as_muscle_stim}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_analyze_wl}()},
\code{\link{read_ddf_dir}()},
\code{\link{read_ddf}()}

Other workloop functions: 
\code{\link{analyze_workloop}()},
\code{\link{fix_GR}()},
\code{\link{invert_position}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_analyze_wl}()},
\code{\link{select_cycles}()},
\code{\link{summarize_wl_trials}()},
\code{\link{time_correct}()}

Other batch analyses: 
\code{\link{read_analyze_wl_dir}()},
\code{\link{summarize_wl_trials}()},
\code{\link{time_correct}()}
}
\author{
Vikram B. Baliga
}
\concept{batch analyses}
\concept{data import functions}
\concept{workloop functions}
