% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_analysis_functions.R
\name{summarize_wl_trials}
\alias{summarize_wl_trials}
\title{Summarize work loop files}
\usage{
summarize_wl_trials(wl_list)
}
\arguments{
\item{wl_list}{List of \code{analyzed_workloop} objects, preferably one
created by \code{read_analyze_wl_dir()}.}
}
\value{
A \code{data.frame} of information about the collection of workloop files.
Columns include:
\item{File_ID }{Name of the file}
\item{Cycle_Frequency }{Frequency of Position change}
\item{Amplitude }{amplitude of Position change}
\item{Phase }{Phase of the oscillatory cycle (in percent) at which
stimulation occurred. Somewhat experimental, please use with caution}
\item{Stimulus_Pulses }{Number of stimulation pulses}
\item{mtime }{Time at which file's contents were last changed (\code{mtime})}
\item{Mean_Work }{Mean work output from the selected cycles}
\item{Mean_Power }{Net power output from the selected cycles}
}
\description{
Summarize important info from work loop files stored in the same folder
(e.g. a sequence of trials in an experiment) including experimental
parameters, run order, and \code{mtime}.
}
\details{
If several files (e.g. successive trials from one experiment) are
stored in one folder, use this function to obtain summary stats and
metadata and other parameters. This function requires a list of
\code{analyze_workloop} objects, which can be readily obtained by first
running \code{read_analyze_wl_dir()} on a specified directory.
}
\examples{

library(workloopR)

# batch read and analyze files included with workloopR
analyzed_wls <- read_analyze_wl_dir(system.file("extdata/wl_duration_trials",
                                               package = 'workloopR'),
                                    phase_from_peak = TRUE,
                                    cycle_def = "p2p",
                                    keep_cycles = 2:4
                                    )

# now summarize
summarized_wls <- summarize_wl_trials(analyzed_wls)

}
\references{
Josephson RK. 1985. Mechanical Power output from Striated Muscle
 during Cyclic Contraction. Journal of Experimental Biology 114: 493-512.
}
\seealso{
\code{\link{read_analyze_wl_dir}},
\code{\link{get_wl_metadata}},
\code{\link{time_correct}}

Other workloop functions: 
\code{\link{analyze_workloop}()},
\code{\link{fix_GR}()},
\code{\link{get_wl_metadata}()},
\code{\link{invert_position}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_analyze_wl}()},
\code{\link{select_cycles}()},
\code{\link{time_correct}()}

Other batch analyses: 
\code{\link{get_wl_metadata}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{time_correct}()}
}
\author{
Vikram B. Baliga and Shreeram Senthivasan
}
\concept{batch analyses}
\concept{workloop functions}
