% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitionPlot.R
\name{partitionPlot}
\alias{partitionPlot}
\title{Make matrix for layout to partition plotting area}
\usage{
partitionPlot(
  nFig,
  returnMatr = TRUE,
  horiz = TRUE,
  figNcol = NULL,
  byrow = TRUE,
  silent = TRUE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{nFig}{(integer) number of figures to be arrages on single plotting surface (ie window or plotting device)}

\item{returnMatr}{(logical) will return matrix ready for use by  \code{\link[graphics]{layout}}; returns vector with nRow and nCol if \code{=FALSE}}

\item{horiz}{(logical) will priviledge horizontal layout if \code{TRUE}}

\item{figNcol}{(integer) optional number of columns}

\item{byrow}{(logical) toggle if output is in order of rows or columns (equivament to \code{\link[base]{matrix}}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additonal messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a matrix for use with \code{layout} or (if \code{returnMatr=FALSE} numeric vector with number of segements in x- an y-axis)
}
\description{
This function proposes a matrix for use with \code{\link[graphics]{layout}} to arrange given number of plots to be placed on a page/plotting area.
In certain instances the proposed layout may accomodate slightly more plots, eg \code{nFig=5} can not be arranged in 2 or 3 columns without an empty last spot.
Portrait (vertival) or lanscape (horizontal) layout proportions can be chosen.  The user can also impose a given number of columns.
}
\examples{
partitionPlot(5); partitionPlot(14,horiz=TRUE)
}
\seealso{
\code{\link[graphics]{layout}}
}
