% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findRepeated.R
\name{findRepeated}
\alias{findRepeated}
\title{Find repeated elements}
\usage{
findRepeated(x, nonRepeated = FALSE, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{x}{character vector}

\item{nonRepeated}{(logical) if \code{=TRUE}, return list with elements \code{$rep} and \code{$nonrep}}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
(named) list of indexes for each of the repeated values, or NULL if all values unique
}
\description{
\code{findRepeated} gets index of repeated items/values in vector 'x' (will be treated as character). 
Return (named) list of indexes for each of the repeated values, or \code{NULL} if all values are unique.
This approach is similar but more basic compared to \code{\link{get1stOfRepeatedByCol}}.
}
\examples{
aa <- c(11:16,14:12,14); findRepeated(aa) 
}
\seealso{
similar approach but more basic than \code{\link{get1stOfRepeatedByCol}}
}
