% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThetaHatStarWrapper.R
\name{ThetaHatStarWrapper}
\alias{ThetaHatStarWrapper}
\title{Monte Carlo Sampling for Parameter Estimates}
\usage{
ThetaHatStarWrapper(
  R = 20000L,
  scale,
  location,
  decomposition = "eigen",
  pd = TRUE,
  tol = 1e-06
)
}
\arguments{
\item{R}{Integer. Number of Monte Carlo samples to generate.}

\item{scale}{Numeric matrix. The covariance matrix of the parameter estimates.}

\item{location}{Numeric vector. The mean (or location) of the parameter estimates.}

\item{decomposition}{Character. Decomposition method for the covariance matrix.
Options: \code{"chol"} (Cholesky), \code{"eigen"} (eigenvalue decomposition), \code{"svd"} (singular value decomposition). Default is \code{"eigen"}.}

\item{pd}{Logical. Ensure positive definiteness of the covariance matrix. Default is \code{TRUE}.}

\item{tol}{Numeric. Tolerance for positive definiteness checks. Default is \code{1e-06}.}
}
\value{
A list containing:
\itemize{
\item \code{thetahatstar}: A matrix of simulated parameter estimates with dimensions \verb{R x length(location)}.
\item \code{decomposition}: The decomposition method used.
}
}
\description{
Generates Monte Carlo samples for parameter estimates using a covariance matrix
and a location vector. This function is a wrapper for the internal \code{.ThetaHatStar()}
function from the \code{semmcci} package.
}
\seealso{
\code{\link[=MCMI2]{MCMI2()}}, \code{\link[=RunMCMIAnalysis]{RunMCMIAnalysis()}}
}
\keyword{internal}
