% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareMissingData.R
\name{PrepareMissingData}
\alias{PrepareMissingData}
\title{Prepare Data with Missing Values for Mediation Analysis}
\usage{
PrepareMissingData(
  data_missing,
  m = 5,
  method_num = "pmm",
  seed = 123,
  M_C1,
  M_C2,
  Y_C1,
  Y_C2,
  C_C1 = NULL,
  C_C2 = NULL,
  C = NULL,
  C_type = NULL,
  W = NULL,
  W_type = NULL,
  center_W = TRUE,
  keep_W_raw = TRUE,
  keep_C_raw = TRUE
)
}
\arguments{
\item{data_missing}{A data frame containing the raw dataset with missing values.}

\item{m}{An integer specifying the number of imputations to perform. Default is \code{5}.}

\item{method_num}{Character; imputation method for numeric variables
(for example, \code{"pmm"}, \code{"norm"}). Default is \code{"pmm"}.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is \code{123}.}

\item{M_C1}{A character vector of column names representing mediators at condition 1.}

\item{M_C2}{A character vector of column names representing mediators at condition 2.
Must match the length of \code{M_C1}.}

\item{Y_C1}{A character string representing the column name of the outcome variable at condition 1.}

\item{Y_C2}{A character string representing the column name of the outcome variable at condition 2.}

\item{C_C1}{Character vector of within-subject control variable names (condition 1).}

\item{C_C2}{Character vector of within-subject control variable names (condition 2).}

\item{C}{Character vector of between-subject control variable names.}

\item{C_type}{Optional vector of the same length as \code{C}.
Each element is \code{"continuous"}, \code{"categorical"}, or \code{"auto"}
(default). Ignored when \code{C = NULL}.}

\item{W}{Optional character vector: moderator names (at most J).}

\item{W_type}{Optional vector of the same length as \code{W}.
Same coding as \code{C_type}. Ignored when \code{W = NULL}.}

\item{center_W}{Logical. Whether to center the moderator variable W.}

\item{keep_W_raw, keep_C_raw}{Logical; keep the original W / C columns
in the returned data?}
}
\value{
A list containing:
\describe{
\item{\code{processed_data_list}}{A list of \code{m} data frames,
each representing an imputed and processed dataset ready for
within-subject mediation analysis.}
\item{\code{imputation_summary}}{A summary of the imputation process,
including diagnostics and convergence information.}
}
}
\description{
Handles missing values in the dataset through multiple imputation
and prepares the imputed datasets for within-subject mediation analysis.
The function imputes missing data, processes each imputed dataset,
and provides diagnostics for the imputation process.
}
\details{
This function is designed to preprocess datasets with missing values
for mediation analysis. It performs the following steps:
\itemize{
\item Multiple imputation: Uses specified imputation methods
(for example, predictive mean matching) to generate
\code{m} imputed datasets.
\item Data preparation: Applies \code{\link{PrepareData}} to each of the
\code{m} imputed datasets to calculate difference scores
and centered averages for mediators and the outcome variable.
\item Imputation diagnostics: Provides summary diagnostics for the imputation
process, including information about missing data patterns and convergence.
}

This function integrates imputation and data preparation, ensuring that
the resulting datasets are ready for subsequent mediation analysis.
}
\examples{
# Example dataset with missing values
data("example_data", package = "wsMed")
set.seed(123)
example_dataN <- mice::ampute(
  data = example_data,
  prop = 0.1
)$amp

# Prepare the dataset with multiple imputations
prepared_missing_data <- PrepareMissingData(
  data_missing = example_dataN,
  m = 5,
  M_C1 = c("A2", "B2"),
  M_C2 = c("A1", "B1"),
  Y_C1 = "C2",
  Y_C2 = "C1"
)

# Access processed datasets
processed_data_list <- prepared_missing_data$processed_data_list
imputation_summary  <- prepared_missing_data$imputation_summary

}
\seealso{
\code{\link{PrepareData}}, \code{\link{ImputeData}}, \code{\link{wsMed}}
}
