% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_flip_y.R
\name{x3p_flip_y}
\alias{x3p_flip_y}
\alias{y_flip_x3p}
\title{Flip the y coordinate of an x3p image}
\usage{
x3p_flip_y(x3p)

y_flip_x3p(x3p)
}
\arguments{
\item{x3p}{x3p object}
}
\value{
x3p object in which the y coordinate is reversed.
}
\description{
One of the major changes between the previous two ISO standards is the
way the y axis is defined in a scan. The entry (0,0) used to refer to the top left corner of a scan, now it refers to the
bottom right corner, which means that all legacy x3p files have to flip their y axis in order to
conform to the newest ISO norm.
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
dim(logo$surface.matrix)
\dontrun{
x3p_image(logo)
}
# flip the y-axis for the old ISO standard:
logoflip <- x3p_flip_y(logo)
dim(logoflip$surface.matrix)
\dontrun{
x3p_image(logoflip)
}
}
