% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xVACalculator.R
\name{xVACalculator}
\alias{xVACalculator}
\title{Calculates the xVA values}
\usage{
xVACalculator(
  trades,
  CSA,
  collateral,
  sim_data,
  reg_data,
  credit_curve_PO,
  credit_curve_cpty,
  funding_curve,
  spot_rates,
  cpty_LGD,
  PO_LGD,
  no_simulations
)
}
\arguments{
\item{trades}{The full list of the Trade Objects}

\item{CSA}{The margin agreement with the counterparty}

\item{collateral}{The amount of collateral currently exchanged with the counterparty}

\item{sim_data}{A list containing data related to the calculation of simulated exposures (for example the model parameters and the number of simulations)}

\item{reg_data}{A list containing data related to the regulatory calculations (for example the 'ccr_framework' member variable can be 'IMM','SACCR','CEM')}

\item{credit_curve_PO}{The credit curve of the processing organization}

\item{credit_curve_cpty}{The credit curve of the processing organization}

\item{funding_curve}{A curve containing the credit spread for the funding of the collateral}

\item{spot_rates}{The spot rates curve}

\item{cpty_LGD}{The loss-given-default of the counterparty}

\item{PO_LGD}{The loss-given-default of the processing organization}

\item{no_simulations}{if true, no simulated exposure will be generated and the regulatory framework should be SA-CCR}
}
\value{
A list containing the xVA values and the cva capital charge
}
\description{
Calculates the xVA values (CVA, DVA, FVA, FBA, MVA, KVA)
}
\references{
Gregory J., The xVA Challenge, 2015, Wiley
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
