% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webcam.R
\name{webcam}
\alias{webcam}
\alias{use_webcam}
\alias{html_dependency_webcam}
\title{Webcam}
\usage{
use_webcam(width = 200, height = 200, margin = "1em")

html_dependency_webcam(width = 200, height = 200, margin = "1em")
}
\arguments{
\item{width, height}{Width and height of the video pane in absolute CSS units,
i.e. as \code{200} or \code{"200px"}.}

\item{margin}{Margin around the video pane in CSS units.}
}
\value{
An \code{htmltools::tagList()} with the HTML dependencies required for
\strong{webcam}.
}
\description{
Add a live video of your webcam into your slides (in your own browser only).
Useful when you are presenting via video conference to include your video,
or when you are recording a class or lecture.
}
\details{
To add \strong{webcam} to your xaringan presentation, add the following code
chunk to your slides’ R Markdown file.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r\}
xaringanExtra::use_webcam()
```
}\if{html}{\out{</div>}}

Inside your slides, press \strong{w} to turn the webcam on and off, or press
\strong{Shift} + \strong{W} to move the video to the next corner. You can also
drag and drop the video within the browser window.
}
\section{Functions}{
\itemize{
\item \code{use_webcam()}: Add the webcam extension to your slides

\item \code{html_dependency_webcam()}: Returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the webcam
dependencies. Most users will want to use \code{use_webcam()}.

}}
\examples{
use_webcam()

}
\references{
The webcam extension is based on the original
\href{https://yihui.org/en/2017/12/html5-camera/}{webcam implementation} by
Yihui Xie, author of \pkg{xaringan}.
}
