% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{ThresholdScaleFitness}
\alias{ThresholdScaleFitness}
\title{Dispersion Ratio Based Threshold Fitness Scaling.}
\usage{
ThresholdScaleFitness(fit, lF)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}
}
\value{
Scaled fitness vector.
}
\description{
Fitness is transformed by a power function 
             with a scaling exponent.
             The choice of the scaling exponent depends on 
             the ratio of the dispersion measures of the 
             current and the previous population fitness.
}
\details{
The scaling exponent is selected by the following rule:
          \itemize{ 
          \item If \code{lF$RDM()>1+lF$ScalingThreshold()} 
                then choose the scaling exponent \code{lF$ScalingExp()}.   
                The scaling exponent should be larger than 1 to increase 
                the selection pressure.
          \item If \code{lF$RDM()<1+lF$SCalingThreshold}
          and \code{lF$RDM()>1-lF$SCalingThreshold}, the fitness is not scaled.
          \item If \code{lF$RDM()<1-lF$SCalingThreshold}
                then choose the scaling exponent \code{lF$ScalingExp2()}.   
                The scaling exponent should be smaller than 1 to decrease 
                the selection pressure.
          }
}
\examples{
lF<-list()
lF$Offset<-parm(0.0001)
lF$ScalingThreshold<-parm(0.05)
lF$RDM<-parm(1.0)
lF$ScalingExp<-parm(2.0)
lF$ScalingExp2<-parm(0.5)
fit<-sample(10, 20, replace=TRUE)
fit
ThresholdScaleFitness(fit, lF)
lF$RDM<-parm(1.2)
ThresholdScaleFitness(fit, lF)
lF$RDM<-parm(0.8)
ThresholdScaleFitness(fit, lF)
}
\seealso{
Other Scaling: 
\code{\link{ContinuousScaleFitness}()},
\code{\link{DispersionRatio}()},
\code{\link{ScaleFitness}()},
\code{\link{ScalingFitness}()}

Other Adaptive Parameter: 
\code{\link{ContinuousScaleFitness}()}
}
\concept{Adaptive Parameter}
\concept{Scaling}
