% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmap_tbl.R
\name{as_xmap_tbl}
\alias{as_xmap_tbl}
\alias{as_xmap_tbl.data.frame}
\alias{diagnose_as_xmap_tbl}
\title{Coercing data frames of links to crossmap tibbles}
\usage{
as_xmap_tbl(x, ...)

\method{as_xmap_tbl}{data.frame}(x, from, to, weight_by, ..., tol = .Machine$double.eps^0.5)

diagnose_as_xmap_tbl(
  x,
  from,
  to,
  weight_by,
  ...,
  tol = .Machine$double.eps^0.5
)
}
\arguments{
\item{x}{A data.frame or tibble to be converted in a crossmap tibble.}

\item{...}{(reserved) Additional arguments passed to methods.}

\item{from}{The column in `x` that specifies the 'from' nodes.}

\item{to}{The column in `x` that specifies the 'to' nodes.}

\item{weight_by}{The column in `x` that specifies the weight of the links.}

\item{tol}{Tolerance of comparison.}
}
\value{
Returns an xmap tibble object.
}
\description{
This method takes a data.frame-like object and converts it into an `xmap_tbl`
based on specified columns for 'from', 'to', and 'weight'.
}
\examples{
demo$abc_links |>
  as_xmap_tbl(from = lower, to = upper, weight_by = share)
}
