% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docinfo.R
\name{docinfo}
\alias{docinfo}
\title{PDF documentation info dictionary object}
\usage{
docinfo(
  author = NULL,
  creation_date = NULL,
  creator = NULL,
  producer = NULL,
  title = NULL,
  subject = NULL,
  keywords = NULL,
  mod_date = NULL
)
}
\arguments{
\item{author}{The document's author.  Matching xmp metadata tag is \code{dc:creator}.}

\item{creation_date}{The date the document was created.
Will be coerced by \code{\link[datetimeoffset:as_datetimeoffset]{datetimeoffset::as_datetimeoffset()}}.
Matching xmp metadata tag is \code{xmp:CreateDate}.}

\item{creator}{The name of the application that originally created the document (if converted to pdf).
Matching xmp metadata tag is \code{xmp:CreatorTool}.}

\item{producer}{The name of the application that converted the document to pdf.
Matching xmp metadata tag is \code{pdf:Producer}.}

\item{title}{The document's title.  Matching xmp metadata tag is \code{dc:title}.}

\item{subject}{The document's subject.  Matching xmp metadata tag is \code{dc:description}.}

\item{keywords}{Keywords for this document (for cross-document searching).
Matching xmp metadata tag is \code{pdf:Keywords}.
Will be coerced into a string by \code{stringi::stri_join(keywords, collapse = ", ")}.}

\item{mod_date}{The date the document was last modified.
Will be coerced by \code{\link[datetimeoffset:as_datetimeoffset]{datetimeoffset::as_datetimeoffset()}}.
Matching xmp metadata tag is \code{xmp:ModifyDate}.}
}
\description{
\code{docinfo()} creates a PDF documentation info dictionary object.
Such objects can be used with \code{\link[=set_docinfo]{set_docinfo()}} to edit PDF documentation info dictionary entries
and such objects are returned by \code{\link[=get_docinfo]{get_docinfo()}}.
}
\section{Known limitations}{

\itemize{
\item Currently does not support arbitrary info dictionary entries.
}
}

\section{\code{docinfo} R6 Class Methods}{
\describe{
\item{\code{get_item(key)}}{Get documentation info value for key \code{key}.
Can also use the relevant active bindings to get documentation info values.}
\item{\code{set_item(key, value)}}{Set documentation info key \code{key} with value \code{value}.
Can also use the relevant active bindings to set documentation info values.}
\item{\code{update(x)}}{Update documentation info key entries
using non-\code{NULL} entries in object \code{x} coerced by \code{\link[=as_docinfo]{as_docinfo()}}.}
}
}

\section{\code{docinfo} R6 Active Bindings}{
\describe{
\item{\code{author}}{The document's author.}
\item{\code{creation_date}}{The date the document was created.}
\item{\code{creator}}{The name of the application that originally created the document (if converted to pdf).}
\item{\code{producer}}{The name of the application that converted the document to pdf.}
\item{\code{title}}{The document's title.}
\item{\code{subject}}{The document's subject.}
\item{\code{keywords}}{Keywords for this document (for cross-document searching).}
\item{\code{mod_date}}{The date the document was last modified.}
}
}

\examples{
if (supports_set_docinfo() && supports_get_docinfo() && require("grid", quietly = TRUE)) {
  f <- tempfile(fileext = ".pdf")
  pdf(f, onefile = TRUE)
  grid.text("Page 1")
  grid.newpage()
  grid.text("Page 2")
  invisible(dev.off())

  cat("\nInitial documentation info\n")
  d <- get_docinfo(f)[[1]]
  print(d)

  d <- update(d,
              author = "John Doe",
              title = "Two Boring Pages",
              keywords = "R, xmpdf")
  set_docinfo(d, f)

  cat("\nDocumentation info after setting it\n")
  print(get_docinfo(f)[[1]])

  unlink(f)
}
}
\seealso{
\code{\link[=get_docinfo]{get_docinfo()}} and \code{\link[=set_docinfo]{set_docinfo()}} for getting/setting such information from/to PDF files.
\code{\link[=as_docinfo]{as_docinfo()}} for coercing to this object.
\code{\link[=as_xmp]{as_xmp()}} can be used to coerce \code{docinfo()} objects into \code{\link[=xmp]{xmp()}} objects.
}
