% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtbetween.R
\name{between_min}
\alias{between_min}
\title{Compute the minimum between-group}
\usage{
between_min(data, variable, id = NULL, t = NULL, na.rm = FALSE)
}
\arguments{
\item{data}{A data.frame or pdata.frame object containing the panel data.}

\item{variable}{The variable for which the minimum between-group effect is calculated.}

\item{id}{(Optional) Name of the individual identifier variable.}

\item{t}{(Optional) Name of the time identifier variable.}

\item{na.rm}{Logical. Should missing values be removed? Default is FALSE.}
}
\value{
The minimum between-group effect.
}
\description{
This function calculates the minimum between-group of a panel data.
}
\examples{
# Example using pdata.frame
data("Gasoline", package = "plm")
Gas <- pdata.frame(Gasoline, index = c("country", "year"), drop.index = TRUE)
between_min(Gas, variable = "lgaspcar")

# Using regular data.frame with id and t specified
data("Crime", package = "plm")
between_min(Crime, variable = "crmrte", id = "county", t = "year")

}
