% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{comparison_table}
\alias{comparison_table}
\title{Create comparison table across groups}
\usage{
comparison_table(object, equation = "mean", output = "data.frame", ...)
}
\arguments{
\item{object}{An object of class "xtvfreg"}

\item{equation}{Character; "mean" or "variance"}

\item{output}{Character; "data.frame", "kable", or "gt"}

\item{...}{Additional arguments passed to formatting functions}
}
\value{
A formatted table (type depends on output parameter)
}
\description{
Create comparison table across groups
}
\examples{
# Create small simulated dataset
set.seed(456)
n_id <- 30
n_time <- 4
panel_data <- data.frame(
  id = factor(rep(1:n_id, each = n_time)),
  group = factor(rep(c("A", "B"), length.out = n_id * n_time)),
  x = rnorm(n_id * n_time)
)
panel_data$m_x <- ave(panel_data$x, panel_data$id, FUN = mean)
panel_data$d_x <- panel_data$x - panel_data$m_x
panel_data$y <- 1 + panel_data$m_x + rnorm(n_id * n_time)

result <- xtvfreg(
  formula = y ~ 1,
  data = panel_data,
  group = "group",
  panel_id = "id",
  mean_vars = c("m_x", "d_x"),
  var_vars = "m_x",
  verbose = FALSE
)

# Create comparison table
comparison_table(result, equation = "mean")
}
