% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{p}
\alias{p}
\alias{ps}
\alias{pss}
\alias{psu}
\alias{psh}
\alias{psnl}
\alias{p0}
\alias{pc}
\alias{pcs}
\alias{pcc}
\alias{pcnl}
\alias{pcsc}
\alias{pc_and}
\alias{pc_or}
\title{paste variants}
\usage{
p(..., sep = "")

ps(...)

pss(...)

psu(...)

psh(...)

psnl(...)

p0(...)

pc(..., sep = "")

pcs(..., sep = "")

pcc(..., sep = "")

pcnl(..., sep = "")

pcsc(..., sep = "")

pc_and(..., sep = "")

pc_or(..., sep = "")
}
\arguments{
\item{..., sep}{passed on to \code{\link[base:paste]{base::paste}}}
}
\description{
Wrappers around \code{\link[base:paste]{base::paste}} with a variety of defaults:
\tabular{llcc}{
   \code{}                   \tab \strong{mnemonic}         \tab \strong{\code{collapse=}} \tab \strong{\code{sep=}} \cr
   \code{p()}, \code{p0()}   \tab paste, paste0             \tab \code{NULL}               \tab \code{""}     \cr
   \code{ps()}, \code{pss()} \tab paste (sep) space         \tab \code{NULL}               \tab \code{" "}    \cr
   \code{psh()}              \tab paste sep hyphen          \tab \code{NULL}               \tab \code{"-"}    \cr
   \code{psu()}              \tab paste sep underscore      \tab \code{NULL}               \tab \code{"_"}    \cr
   \code{psnl()}             \tab paste sep newline         \tab \code{NULL}               \tab \code{"\n"}   \cr
   \code{pc()}               \tab paste collapse            \tab \code{""}                 \tab \code{""}     \cr
   \code{pcs()}              \tab paste collapse space      \tab \code{" "}                \tab \code{""}     \cr
   \code{pcc()}              \tab paste collapse comma      \tab \code{", "}               \tab \code{""}     \cr
   \code{pcsc()}             \tab paste collapse semicolon  \tab \code{"; "}               \tab \code{""}     \cr
   \code{pcnl()}             \tab paste collapse newline    \tab \code{"\n"}               \tab \code{""}     \cr
   \code{pc_and()}           \tab paste collapse and        \tab \emph{varies}             \tab \code{""}     \cr
   \code{pc_or()}            \tab paste collapse or         \tab \emph{varies}             \tab \code{""}     \cr
}
}
\examples{
x <- head(letters, 3)
y <- tail(letters, 3)
# paste
p(x, y)
p0(x, y)
# paste + collapse
pc(x)
pc(x, y)
pcs(x)
pcc(x)
pcc(x, y)
pcsc(x)
pcnl(x)
pc_and(x[1:2])
pc_and(x[1:3])
pc_or(x[1:2])
pc_or(x[1:3])
pc_and(x, y)
pc_and(x, y, sep = "-")
pc_and(x[1])
pc_and(x[0])
}
\seealso{
\code{\link{wrap}} \code{\link{sentence}}
}
