% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{ypr_population}
\alias{ypr_population}
\title{Population Parameters}
\usage{
ypr_population(
  tmax = 20L,
  k = 0.15,
  Linf = 100,
  t0 = 0,
  k2 = 0.15,
  Linf2 = 100,
  L2 = 1000,
  Wb = 3,
  Ls = 50,
  Sp = 100,
  es = 1,
  Sm = 0,
  fb = 1,
  tR = 1L,
  BH = 1L,
  Rk = 3,
  n = 0.2,
  nL = 0.2,
  Ln = 1000,
  Lv = 50,
  Vp = 100,
  Llo = 0,
  Lup = 1000,
  Nc = 0,
  pi = 0.2,
  rho = 0,
  Hm = 0,
  Rmax = 1,
  Wa = 0.01,
  fa = 1,
  q = 0.1,
  RPR = 1
)
}
\arguments{
\item{tmax}{The maximum age (yr).}

\item{k}{The VB growth coefficient (yr-1).}

\item{Linf}{The VB mean maximum length (cm).}

\item{t0}{The (theoretical) age at zero length (yr).}

\item{k2}{The VB growth coefficient after length L2 (yr-1).}

\item{Linf2}{The VB mean maximum length after length L2 (cm).}

\item{L2}{The length (or age if negative) at which growth switches from the
first to second phase (cm or yr).}

\item{Wb}{The weight (as a function of length) scaling exponent.}

\item{Ls}{The length (or age if negative) at which 50 \% mature (cm or yr).}

\item{Sp}{The maturity (as a function of length) power.}

\item{es}{The annual probability of a mature fish spawning.}

\item{Sm}{The spawning mortality probability.}

\item{fb}{The fecundity (as a function of weight) scaling exponent.}

\item{tR}{The age from which survival is density-independent (yr).}

\item{BH}{Recruitment follows a Beverton-Holt (1) or Ricker (0) relationship.}

\item{Rk}{The lifetime spawners per spawner at low density (or the egg to tR survival if between 0 and 1).}

\item{n}{The annual interval natural mortality rate from age tR.}

\item{nL}{The annual interval natural mortality rate from length Ln.}

\item{Ln}{The length  (or age if negative) at which the natural mortality
rate switches from n to nL (cm or yr).}

\item{Lv}{The length (or age if negative) at which 50 \% vulnerable to harvest
(cm or yr).}

\item{Vp}{The vulnerability to harvest (as a function of length) power.}

\item{Llo}{The lower harvest slot length (cm).}

\item{Lup}{The upper harvest slot length (cm).}

\item{Nc}{The slot limits non-compliance probability.}

\item{pi}{The annual capture probability.}

\item{rho}{The release probability.}

\item{Hm}{The hooking mortality probability.}

\item{Rmax}{The number of recruits at the carrying capacity (ind).}

\item{Wa}{The (extrapolated) weight of a 1 cm individual (g).}

\item{fa}{The (theoretical) fecundity of a 1 g female (eggs).}

\item{q}{The catchability (annual probability of capture) for a unit of
effort.}

\item{RPR}{The relative proportion of recruits that are of the ecotype.}
}
\value{
An object of class \code{ypr_population}.
}
\description{
Generates an object of class \code{ypr_population}.
}
\examples{
ypr_population(k = 0.1, Linf = 90)
}
