% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_yaml_fragments.R
\name{extract_yaml_fragments}
\alias{extract_yaml_fragments}
\title{Extract all YAML fragments from a file}
\usage{
extract_yaml_fragments(
  text,
  file,
  delimiterRegEx = "^---$",
  ignoreOddDelimiters = FALSE,
  encoding = "UTF-8",
  silent = TRUE
)
}
\arguments{
\item{text, file}{As \code{text} or \code{file}, you can specify a \code{file} to read with
encoding \code{encoding}, which will then be read using \code{\link[base:readLines]{base::readLines()}}. If the
argument is named \code{text}, whether it is the path to an existing file is checked
first, and if it is, that file is read. If the argument is named \code{file}, and it
does not point to an existing file, an error is produced (useful if calling
from other functions). A \code{text} should be a character vector where every
element is a line of the original source (like provided by \code{\link[base:readLines]{base::readLines()}});
although if a character vector of one element \emph{and} including at least one
newline character (\verb{\\\\n}) is provided as \code{text}, it is split at the newline
characters using \code{\link[base:strsplit]{base::strsplit()}}. Basically, this behavior means that the
first argument can be either a character vector or the path to a file; and if
you're specifying a file and you want to be certain that an error is thrown if
it doesn't exist, make sure to name it \code{file}.}

\item{delimiterRegEx}{The regular expression used to locate YAML
fragments.}

\item{ignoreOddDelimiters}{Whether to throw an error (FALSE) or
delete the last delimiter (TRUE) if an odd number of delimiters is
encountered.}

\item{encoding}{The encoding to use when calling \code{\link[=readLines]{readLines()}}. Set to
NULL to let \code{\link[=readLines]{readLines()}} guess.}

\item{silent}{Whether to be silent (\code{TRUE}) or informative (\code{FALSE}).}
}
\value{
A list of character vectors, where each vector corresponds to
one YAML fragment in the source file or text.
}
\description{
These function extracts all YAML fragments from a file,
returning a list of character vectors containing the extracted
fragments.
}
\examples{
extract_yaml_fragments(text="
---
First: YAML fragment
  id: firstFragment
---
Outside of YAML
---
Second: YAML fragment
  id: secondFragment
  parentId: firstFragment
---
Also outside of YAML
");
}
