% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunking_regular.R
\docType{class}
\name{chunk_grid_regular}
\alias{chunk_grid_regular}
\title{Chunk management}
\description{
This class implements the regular chunk grid for Zarr
arrays. It manages reading from and writing to Zarr stores, using the
codecs for data transformation.
}
\section{Super class}{
\code{\link[zarr:zarr_extension]{zarr::zarr_extension}} -> \code{chunk_grid_regular}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{chunk_shape}}{(read-only) The dimensions of each chunk in the chunk
grid of the associated array.}

\item{\code{chunk_grid}}{(read-only) The chunk grid of the associated array,
i.e. the number of chunks in each dimension.}

\item{\code{chunk_separator}}{Set or retrieve the separator to be used for
creating store keys for chunks.}

\item{\code{data_type}}{The data type of the array using the chunking scheme.
This is set by the array when starting to use chunking for file I/O.}

\item{\code{codecs}}{The list of codecs used by the chunking scheme. These are
set by the array when starting to use chunking for file I/O. Upon
reading, the list of registered codecs.}

\item{\code{store}}{The store of the array using the chunking scheme.
This is set by the array when starting to use chunking for file I/O.}

\item{\code{array_prefix}}{The prefix of the array using the chunking scheme.
This is set by the array when starting to use chunking for file I/O.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-chunk_grid_regular-new}{\code{chunk_grid_regular$new()}}
\item \href{#method-chunk_grid_regular-print}{\code{chunk_grid_regular$print()}}
\item \href{#method-chunk_grid_regular-metadata_fragment}{\code{chunk_grid_regular$metadata_fragment()}}
\item \href{#method-chunk_grid_regular-read}{\code{chunk_grid_regular$read()}}
\item \href{#method-chunk_grid_regular-write}{\code{chunk_grid_regular$write()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chunk_grid_regular-new"></a>}}
\if{latex}{\out{\hypertarget{method-chunk_grid_regular-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new chunking scheme for an array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{chunk_grid_regular$new(array_shape, chunk_shape)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{array_shape}}{Integer vector of the array dimensions.}

\item{\code{chunk_shape}}{Integer vector of the dimensions of each chunk.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of \code{chunk_grid_regular}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chunk_grid_regular-print"></a>}}
\if{latex}{\out{\hypertarget{method-chunk_grid_regular-print}{}}}
\subsection{Method \code{print()}}{
Print a short description of this chunking scheme to the
console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{chunk_grid_regular$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chunk_grid_regular-metadata_fragment"></a>}}
\if{latex}{\out{\hypertarget{method-chunk_grid_regular-metadata_fragment}{}}}
\subsection{Method \code{metadata_fragment()}}{
Return the metadata fragment that describes this chunking
scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{chunk_grid_regular$metadata_fragment()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the metadata of this codec.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chunk_grid_regular-read"></a>}}
\if{latex}{\out{\hypertarget{method-chunk_grid_regular-read}{}}}
\subsection{Method \code{read()}}{
Read data from the Zarr array into an R object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{chunk_grid_regular$read(start, stop)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start, stop}}{Integer vectors of the same length as the
dimensionality of the Zarr array, indicating the starting and ending
(inclusive) indices of the data along each axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector, matrix or array of data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chunk_grid_regular-write"></a>}}
\if{latex}{\out{\hypertarget{method-chunk_grid_regular-write}{}}}
\subsection{Method \code{write()}}{
Write data to the array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{chunk_grid_regular$write(data, start, stop)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{An R object with the same dimensionality as the Zarr array.}

\item{\code{start, stop}}{Integer vectors of the same length as the
dimensionality of the Zarr array, indicating the starting and ending
(inclusive) indices of the data along each axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
}
