% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled_light.R
\name{threadbare}
\alias{threadbare}
\title{Return a threadbare version of a vector}
\usage{
threadbare(x)
}
\arguments{
\item{x}{A vector, possibly classed, but not a list object, to strip of all
attributes.}
}
\value{
A vector with the same core values as \code{x}, but with no \code{\link[=attributes]{attributes()}}
at all, not even \code{\link[=names]{names()}}.
}
\description{
A bare object is an R object that has no class attributes (see
\code{\link[rlang:bare-type-predicates]{rlang::is_bare_character()}}). A threadbare object is an atomic object (i.e.
not a \code{\link[=list]{list()}}, see \code{\link[=is.atomic]{is.atomic()}}), with no attributes at all. The function
returns an error if a list is passed.
}
\seealso{
Other labelled light: 
\code{\link{ll_assert_labelled}()},
\code{\link{ll_labelled}()},
\code{\link{ll_to_character}()},
\code{\link{ll_val_labels}()},
\code{\link{ll_var_label}()}
}
\concept{labelled light}
\keyword{internal}
